/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry.support.command;

import com.networknt.exception.FrameworkException;
import com.networknt.registry.NotifyListener;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.registry.URLParamType;
import com.networknt.registry.support.command.CommandFailbackRegistry;
import com.networknt.registry.support.command.RpcCommand;
import com.networknt.registry.support.command.ServiceListener;
import com.networknt.status.Status;
import com.networknt.switcher.SwitcherUtil;
import com.networknt.utility.ConcurrentHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandServiceManager
implements ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(CommandServiceManager.class);
    private static final String REGISTRY_IS_NULL = "ERR10024";
    private static final String WEIGHT_OUT_OF_RANGE = "ERR10025";
    public static final String LIGHT_COMMAND_SWITCHER = "feature.light.command.enable";
    private URL refUrl;
    private ConcurrentHashSet<NotifyListener> notifySet;
    private CommandFailbackRegistry registry;
    private Map<String, List<URL>> groupServiceCache;

    public CommandServiceManager(URL refUrl) {
        if (logger.isInfoEnabled()) {
            logger.info("CommandServiceManager init url:" + refUrl.toFullStr());
        }
        this.refUrl = refUrl;
        this.notifySet = new ConcurrentHashSet();
        this.groupServiceCache = new ConcurrentHashMap<String, List<URL>>();
    }

    @Override
    public void notifyService(URL serviceUrl, URL registryUrl, List<URL> urls) {
        if (this.registry == null) {
            throw new FrameworkException(new Status(REGISTRY_IS_NULL, new Object[0]));
        }
        URL urlCopy = serviceUrl.createCopy();
        String groupName = urlCopy.getParameter(URLParamType.group.getName(), URLParamType.group.getValue());
        this.groupServiceCache.put(groupName, urls);
        ArrayList<URL> finalResult = new ArrayList<URL>();
        if (logger.isInfoEnabled()) {
            logger.info("command cache is null. service:" + serviceUrl.toSimpleString());
        }
        finalResult.addAll(this.discoverOneGroup(this.refUrl));
        for (NotifyListener notifyListener : this.notifySet) {
            notifyListener.notify(this.registry.getUrl(), finalResult);
        }
    }

    private void buildWeightsMap(Map<String, Integer> weights, RpcCommand.ClientCommand command) {
        for (String rule : command.getMergeGroups()) {
            String[] gw = rule.split(":");
            int weight = 1;
            if (gw.length > 1) {
                try {
                    weight = Integer.parseInt(gw[1]);
                }
                catch (NumberFormatException e) {
                    throw new FrameworkException(new Status(WEIGHT_OUT_OF_RANGE, new Object[]{weight}));
                }
                if (weight < 0 || weight > 100) {
                    throw new FrameworkException(new Status(WEIGHT_OUT_OF_RANGE, new Object[]{weight}));
                }
            }
            weights.put(gw[0], weight);
        }
    }

    private List<URL> mergeResult(URL url, Map<String, Integer> weights) {
        ArrayList<URL> finalResult = new ArrayList<URL>();
        if (weights.size() > 1) {
            URLImpl ruleUrl = new URLImpl("rule", url.getHost(), url.getPort(), url.getPath());
            StringBuilder weightsBuilder = new StringBuilder(64);
            for (Map.Entry<String, Integer> entry : weights.entrySet()) {
                weightsBuilder.append(entry.getKey()).append(':').append(entry.getValue()).append(',');
            }
            ruleUrl.addParameter(URLParamType.weights.getName(), weightsBuilder.deleteCharAt(weightsBuilder.length() - 1).toString());
            finalResult.add(ruleUrl);
        }
        for (String key : weights.keySet()) {
            if (this.groupServiceCache.containsKey(key)) {
                finalResult.addAll((Collection<URL>)this.groupServiceCache.get(key));
                continue;
            }
            URL urlTemp = url.createCopy();
            urlTemp.addParameter(URLParamType.group.getName(), key);
            finalResult.addAll(this.discoverOneGroup(urlTemp));
            this.registry.subscribeService(urlTemp, this);
        }
        return finalResult;
    }

    private List<URL> discoverOneGroup(URL urlCopy) {
        String group;
        List<URL> list;
        if (logger.isInfoEnabled()) {
            logger.info("CommandServiceManager discover one group. url:" + urlCopy.toSimpleString());
        }
        if ((list = this.groupServiceCache.get(group = urlCopy.getParameter(URLParamType.group.getName(), URLParamType.group.getValue()))) == null) {
            list = this.registry.discoverService(urlCopy);
            this.groupServiceCache.put(group, list);
        }
        return list;
    }

    public void addNotifyListener(NotifyListener notifyListener) {
        this.notifySet.add((Object)notifyListener);
    }

    public void removeNotifyListener(NotifyListener notifyListener) {
        this.notifySet.remove((Object)notifyListener);
    }

    public void setRegistry(CommandFailbackRegistry registry) {
        this.registry = registry;
    }

    static {
        SwitcherUtil.initSwitcher((String)LIGHT_COMMAND_SWITCHER, (boolean)true);
    }
}

