/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.zookeeper;

import com.networknt.exception.FrameworkException;
import com.networknt.registry.URL;
import com.networknt.status.Status;
import com.networknt.zookeeper.ZkNodeType;

public class ZkUtils {
    private static final String GET_NODETYPEPATH_ERROR = "ERR10026";

    public static String toGroupPath(URL url) {
        return "/light/" + url.getGroup();
    }

    public static String toServicePath(URL url) {
        return ZkUtils.toGroupPath(url) + "/" + url.getPath();
    }

    public static String toCommandPath(URL url) {
        return ZkUtils.toGroupPath(url) + "/command";
    }

    public static String toNodeTypePath(URL url, ZkNodeType nodeType) {
        String type;
        if (nodeType == ZkNodeType.AVAILABLE_SERVER) {
            type = "server";
        } else if (nodeType == ZkNodeType.UNAVAILABLE_SERVER) {
            type = "unavailableServer";
        } else if (nodeType == ZkNodeType.CLIENT) {
            type = "client";
        } else {
            throw new FrameworkException(new Status(GET_NODETYPEPATH_ERROR, new Object[]{url, nodeType.toString()}));
        }
        return ZkUtils.toServicePath(url) + "/" + type;
    }

    public static String toNodePath(URL url, ZkNodeType nodeType) {
        return ZkUtils.toNodeTypePath(url, nodeType) + "/" + url.getServerPortStr();
    }
}

