/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo.app.Component;
import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import nextapp.echo.extras.app.viewer.Viewer;
import nextapp.echo.extras.app.viewer.ViewerModel;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.SynchronizationContext;
import nextapp.echo.webcontainer.SynchronizationException;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractViewerPeer
extends AbstractComponentSynchronizePeer {
    private static final Service MODEL_SERVICE = new Service(){
        private static final int MAX_SIZE = 4096;

        public String getId() {
            return "EchoExtras.Viewer.Model";
        }

        public int getVersion() {
            return -1;
        }

        public void service(Connection conn) throws IOException {
            try {
                HttpServletRequest request = conn.getRequest();
                String clientRenderId = request.getParameter("cid");
                Viewer viewer = (Viewer)conn.getUserInstance().getComponentByClientRenderId(clientRenderId);
                int startIndex = Integer.parseInt(request.getParameter("is"));
                int endIndex = Integer.parseInt(request.getParameter("ie"));
                int indexCount = endIndex - startIndex + 1;
                if (indexCount > 4096) {
                    throw new IOException("Model request for " + indexCount + " cells exceeded maximum size of " + indexCount + " indices.");
                }
                ViewerModel model = viewer.getModel();
                ModelData modelData = new ModelData(model, startIndex, endIndex);
                Document document = DomUtil.createDocument((String)"model", null, null, null);
                SynchronizationContext context = new SynchronizationContext(conn, document);
                Element modelElement = document.getDocumentElement();
                modelElement.setAttribute("sz", Integer.toString(model.size()));
                modelElement.setAttribute("is", Integer.toString(modelData.getStartIndex()));
                modelElement.setAttribute("ie", Integer.toString(modelData.getEndIndex()));
                AbstractViewerPeer.renderModelDataContent((Context)context, modelData, modelElement);
                conn.setContentType(ContentType.TEXT_XML);
                DomUtil.save((Document)document, (OutputStream)conn.getOutputStream(), null);
                DomUtil.save((Document)document, (PrintWriter)new PrintWriter(System.err), null);
            }
            catch (SerialException ex) {
                throw new SynchronizationException("Unable to render model data.", (Throwable)ex);
            }
            catch (SAXException ex) {
                throw new SynchronizationException("Unable to render model data.", (Throwable)ex);
            }
        }
    };
    private static final Service BASE_JS_SERVICE = JavaScriptService.forResources((String)"EchoExtras.Viewer", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.Viewer.js", "nextapp/echo/extras/webcontainer/resource/Sync.Viewer.js", "nextapp/echo/extras/webcontainer/resource/RemoteClient.Viewer.js"});
    static /* synthetic */ Class class$nextapp$echo$extras$app$viewer$ViewerModel;

    public static void renderModelDataContent(Context context, ModelData modelData, Element parentElement) throws SerialException {
        PropertyPeerFactory factory = (PropertyPeerFactory)context.get(PropertyPeerFactory.class);
        int endIndex = Math.min(modelData.getEndIndex(), modelData.getModel().size());
        for (int i = modelData.getStartIndex(); i < endIndex; ++i) {
            Element pElement;
            Object modelValue = modelData.getModel().get(i);
            if (modelValue == null) {
                pElement = parentElement.getOwnerDocument().createElement("p");
                parentElement.appendChild(pElement);
                continue;
            }
            if (modelValue instanceof Object[]) {
                Object[] array = (Object[])modelValue;
                for (int iArray = 0; iArray < array.length; ++iArray) {
                    if (array[iArray] == null) continue;
                    Element pElement2 = parentElement.getOwnerDocument().createElement("p");
                    pElement2.setAttribute("x", Integer.toString(iArray));
                    SerialPropertyPeer modelValuePeer = factory.getPeerForProperty(array[iArray].getClass());
                    modelValuePeer.toXml(context, class$nextapp$echo$extras$app$viewer$ViewerModel == null ? AbstractViewerPeer.class$("nextapp.echo.extras.app.viewer.ViewerModel") : class$nextapp$echo$extras$app$viewer$ViewerModel, pElement2, array[iArray]);
                    parentElement.appendChild(pElement2);
                }
                continue;
            }
            pElement = parentElement.getOwnerDocument().createElement("p");
            SerialPropertyPeer modelValuePeer = factory.getPeerForProperty(modelValue.getClass());
            modelValuePeer.toXml(context, class$nextapp$echo$extras$app$viewer$ViewerModel == null ? AbstractViewerPeer.class$("nextapp.echo.extras.app.viewer.ViewerModel") : class$nextapp$echo$extras$app$viewer$ViewerModel, pElement, modelValue);
            parentElement.appendChild(pElement);
        }
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(BASE_JS_SERVICE.getId());
    }

    static {
        WebContainerServlet.getServiceRegistry().add(BASE_JS_SERVICE);
        WebContainerServlet.getServiceRegistry().add(MODEL_SERVICE);
    }

    public static class ModelDataPeer
    implements SerialPropertyPeer {
        public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
            throw new UnsupportedOperationException();
        }

        public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
            propertyElement.setAttribute("t", "Extras.Sync.RemoteViewer.ModelData");
            ModelData modelData = (ModelData)propertyValue;
            ViewerModel model = modelData.getModel();
            Element modelElement = propertyElement.getOwnerDocument().createElement("model");
            int size = model.size();
            modelElement.setAttribute("sz", Integer.toString(size));
            modelElement.setAttribute("is", Integer.toString(modelData.getStartIndex()));
            modelElement.setAttribute("ie", Integer.toString(Math.min(size, modelData.getEndIndex())));
            AbstractViewerPeer.renderModelDataContent(context, modelData, modelElement);
            propertyElement.appendChild(modelElement);
        }
    }

    public static class ModelData {
        private int startIndex;
        private int endIndex;
        private ViewerModel model;

        public ModelData(ViewerModel model, int startIndex, int endIndex) {
            this.model = model;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            model.fetch(startIndex, endIndex);
        }

        public ViewerModel getModel() {
            return this.model;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

