/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import nextapp.echo.app.Component;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.CalendarSelect;
import nextapp.echo.extras.webcontainer.CommonResources;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ResourceRegistry;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class CalendarSelectPeer
extends AbstractComponentSynchronizePeer {
    private static final String RESOURCE_DIR = "nextapp/echo/extras/webcontainer/resource/";
    private static final Service CALENDAR_SELECT_SERVICE = JavaScriptService.forResources((String)"EchoExtras.CalendarSelect", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.CalendarSelect.js", "nextapp/echo/extras/webcontainer/resource/Sync.CalendarSelect.js"});
    private static final Map LOCALE_SERVICES = new HashMap();

    private static void addLocaleService(Locale locale, String localeCode) {
        JavaScriptService service = JavaScriptService.forResource((String)("EchoExtras.CalendarSelect." + localeCode), (String)("nextapp/echo/extras/webcontainer/resource/SyncLocale.CalendarSelect." + localeCode + ".js"));
        WebContainerServlet.getServiceRegistry().add((Service)service);
        LOCALE_SERVICES.put(locale, service);
    }

    public CalendarSelectPeer() {
        this.addOutputProperty("date");
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("action", "actionListeners"){

            public boolean hasListeners(Context context, Component c) {
                return ((CalendarSelect)c).hasActionListeners();
            }
        });
    }

    public String getClientComponentType(boolean mode) {
        return "Extras.CalendarSelect";
    }

    public Class getComponentClass() {
        return CalendarSelect.class;
    }

    public Class getInputPropertyClass(String propertyName) {
        if ("date".equals(propertyName)) {
            return Date.class;
        }
        return null;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if (propertyName.equals("date")) {
            CalendarSelect calendarSelect = (CalendarSelect)component;
            return calendarSelect.getDate();
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(CALENDAR_SELECT_SERVICE.getId());
        this.installLocaleService(context, component);
    }

    private void installLocaleService(Context context, Component component) {
        Locale locale = component.getRenderLocale();
        if (LOCALE_SERVICES.containsKey(locale)) {
            ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
            serverMessage.addLibrary(((Service)LOCALE_SERVICES.get(locale)).getId());
        }
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int propertyIndex, Object newValue) {
        if (propertyName.equals("date")) {
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, "date", newValue);
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(CALENDAR_SELECT_SERVICE);
        CommonResources.install();
        ResourceRegistry resources = WebContainerServlet.getResourceRegistry();
        resources.add("Extras", "image/calendar/Increment.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/calendar/Decrement.gif", ContentType.IMAGE_GIF);
        CalendarSelectPeer.addLocaleService(Locale.GERMAN, "de");
        CalendarSelectPeer.addLocaleService(new Locale("bg"), "bg");
    }
}

