/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo.app.Component;
import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import nextapp.echo.extras.app.DataGrid;
import nextapp.echo.extras.app.datagrid.DataGridModel;
import nextapp.echo.extras.app.datagrid.PrefetchDataGridModel;
import nextapp.echo.extras.webcontainer.CommonResources;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.ServiceRegistry;
import nextapp.echo.webcontainer.SynchronizationContext;
import nextapp.echo.webcontainer.SynchronizationException;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DataGridPeer
extends AbstractComponentSynchronizePeer {
    private static final Service MODEL_SERVICE = new Service(){
        private static final int MAX_SIZE = 4096;

        public String getId() {
            return "EchoExtras.DataGrid.Model";
        }

        public int getVersion() {
            return -1;
        }

        public void service(Connection conn) throws IOException {
            try {
                HttpServletRequest request = conn.getRequest();
                String clientRenderId = request.getParameter("cid");
                DataGrid dataGrid = (DataGrid)conn.getUserInstance().getComponentByClientRenderId(clientRenderId);
                int firstColumn = Integer.parseInt(request.getParameter("x1"));
                int lastColumn = Integer.parseInt(request.getParameter("x2"));
                int firstRow = Integer.parseInt(request.getParameter("y1"));
                int lastRow = Integer.parseInt(request.getParameter("y2"));
                int size = (lastRow - firstRow + 1) * (lastColumn - firstColumn + 1);
                if (size > 4096) {
                    throw new IOException("Model request for " + size + " cells exceeded maximum size of " + 4096 + " cells.");
                }
                ModelData modelData = new ModelData(dataGrid.getModel(), firstColumn, firstRow, lastColumn, lastRow);
                Document document = DomUtil.createDocument((String)"model", null, null, null);
                SynchronizationContext context = new SynchronizationContext(conn, document);
                DataGridPeer.renderModelDataContent((Context)context, modelData, document.getDocumentElement());
                conn.setContentType(ContentType.TEXT_XML);
                DomUtil.save((Document)document, (OutputStream)conn.getOutputStream(), null);
            }
            catch (SerialException ex) {
                throw new SynchronizationException("Unable to render model data.", (Throwable)ex);
            }
            catch (SAXException ex) {
                throw new SynchronizationException("Unable to render model data.", (Throwable)ex);
            }
        }
    };
    private static final Service SCRIPT_SERVICE = JavaScriptService.forResources((String)"EchoExtras.DataGrid", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.DataGrid.js", "nextapp/echo/extras/webcontainer/resource/Sync.DataGrid.js", "nextapp/echo/extras/webcontainer/resource/RemoteClient.DataGrid.js"});
    static /* synthetic */ Class class$nextapp$echo$extras$app$datagrid$DataGridModel;

    public static void renderModelDataContent(Context context, ModelData modelData, Element parentElement) throws SerialException {
        PropertyPeerFactory factory = (PropertyPeerFactory)context.get(PropertyPeerFactory.class);
        for (int row = modelData.getFirstRow(); row <= modelData.getLastRow(); ++row) {
            for (int column = modelData.getFirstColumn(); column <= modelData.getLastColumn(); ++column) {
                Element pElement = parentElement.getOwnerDocument().createElement("p");
                Object modelValue = modelData.getModel().get(column, row);
                if (modelValue != null) {
                    SerialPropertyPeer modelValuePeer = factory.getPeerForProperty(modelValue.getClass());
                    modelValuePeer.toXml(context, class$nextapp$echo$extras$app$datagrid$DataGridModel == null ? DataGridPeer.class$("nextapp.echo.extras.app.datagrid.DataGridModel") : class$nextapp$echo$extras$app$datagrid$DataGridModel, pElement, modelValue);
                }
                parentElement.appendChild(pElement);
            }
        }
    }

    public DataGridPeer() {
        this.addOutputProperty("model");
        this.addOutputProperty("columnIndex");
        this.addOutputProperty("rowIndex");
        this.addOutputProperty("columnPercent");
        this.addOutputProperty("rowPercent");
    }

    public String getClientComponentType(boolean mode) {
        return "Extras.RemoteDataGrid";
    }

    public Class getComponentClass() {
        return DataGrid.class;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        DataGrid dataGrid = (DataGrid)component;
        if (propertyName.equals("model")) {
            return new ModelData(dataGrid.getModel(), 0, 0, 19, 19);
        }
        if (propertyName.equals("columnIndex")) {
            return dataGrid.getColumnIndex();
        }
        if (propertyName.equals("rowIndex")) {
            return dataGrid.getRowIndex();
        }
        if (propertyName.equals("columnPercent")) {
            return dataGrid.getColumnPercent();
        }
        if (propertyName.equals("rowPercent")) {
            return dataGrid.getRowPercent();
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(SCRIPT_SERVICE.getId());
    }

    static {
        CommonResources.install();
        ServiceRegistry services = WebContainerServlet.getServiceRegistry();
        services.add(SCRIPT_SERVICE);
        services.add(MODEL_SERVICE);
    }

    public static class ModelDataPeer
    implements SerialPropertyPeer {
        public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
            throw new UnsupportedOperationException();
        }

        public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
            propertyElement.setAttribute("t", "Extras.RemoteDataGrid.Model");
            ModelData modelData = (ModelData)propertyValue;
            DataGridModel model = modelData.getModel();
            Element modelElement = propertyElement.getOwnerDocument().createElement("model");
            modelElement.setAttribute("cc", Integer.toString(model.getColumnCount()));
            modelElement.setAttribute("rc", Integer.toString(model.getRowCount()));
            modelElement.setAttribute("x1", Integer.toString(modelData.getFirstColumn()));
            modelElement.setAttribute("y1", Integer.toString(modelData.getFirstRow()));
            modelElement.setAttribute("x2", Integer.toString(modelData.getLastColumn()));
            modelElement.setAttribute("y2", Integer.toString(modelData.getLastRow()));
            DataGridPeer.renderModelDataContent(context, modelData, modelElement);
            propertyElement.appendChild(modelElement);
        }
    }

    public static class ModelData {
        private int firstColumn;
        private int firstRow;
        private int lastColumn;
        private int lastRow;
        private DataGridModel model;

        public ModelData(DataGridModel model, int firstColumn, int firstRow, int lastColumn, int lastRow) {
            this.model = model;
            this.firstColumn = firstColumn;
            this.firstRow = firstRow;
            this.lastColumn = lastColumn;
            this.lastRow = lastRow;
            if (model instanceof PrefetchDataGridModel) {
                ((PrefetchDataGridModel)model).prefetch(firstColumn, firstRow, lastColumn, lastRow);
            }
        }

        public DataGridModel getModel() {
            return this.model;
        }

        public int getFirstColumn() {
            return this.firstColumn;
        }

        public int getFirstRow() {
            return this.firstRow;
        }

        public int getLastColumn() {
            return this.lastColumn;
        }

        public int getLastRow() {
            return this.lastRow;
        }
    }
}

