/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import java.util.StringTokenizer;
import nextapp.echo.app.Component;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.Reorder;
import nextapp.echo.extras.webcontainer.CommonResources;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ResourceRegistry;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.ServiceRegistry;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class ReorderPeer
extends AbstractComponentSynchronizePeer {
    static final Service REORDER_SERVICE = JavaScriptService.forResources((String)"EchoExtras.Reorder", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.Reorder.js", "nextapp/echo/extras/webcontainer/resource/Sync.Reorder.js", "nextapp/echo/extras/webcontainer/resource/Sync.RemoteReorder.js"});

    public ReorderPeer() {
        this.addOutputProperty("order");
    }

    public String getClientComponentType(boolean mode) {
        return "Extras.RemoteReorder";
    }

    public Class getComponentClass() {
        return Reorder.class;
    }

    public Class getInputPropertyClass(String propertyName) {
        if ("order".equals(propertyName)) {
            return String.class;
        }
        return null;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if ("order".equals(propertyName)) {
            int[] order = ((Reorder)component).getOrder();
            if (order == null) {
                return null;
            }
            StringBuffer out = new StringBuffer();
            for (int i = 0; i < order.length; ++i) {
                if (i > 0) {
                    out.append(",");
                }
                out.append(order[i]);
            }
            System.err.println("getOrder:" + out);
            return out.toString();
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public String getOutputPropertyMethodName(Context context, Component component, String propertyName) {
        if ("order".equals(propertyName)) {
            return "loadOrder";
        }
        return super.getOutputPropertyMethodName(context, component, propertyName);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(REORDER_SERVICE.getId());
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int propertyIndex, Object newValue) {
        if (propertyName.equals("order")) {
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            String orderString = (String)newValue;
            StringTokenizer st = new StringTokenizer(orderString, ",");
            int[] order = new int[component.getComponentCount()];
            for (int i = 0; st.hasMoreTokens() && i < order.length; ++i) {
                String s = st.nextToken();
                order[i] = Integer.parseInt(s);
            }
            clientUpdateManager.setComponentProperty(component, "order", (Object)order);
        }
    }

    static {
        CommonResources.install();
        ResourceRegistry resources = WebContainerServlet.getResourceRegistry();
        resources.add("Extras", "image/reorder/Icon32Move.png", ContentType.IMAGE_PNG);
        ServiceRegistry services = WebContainerServlet.getServiceRegistry();
        services.add(REORDER_SERVICE);
    }
}

