/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import java.util.Iterator;
import nextapp.echo.app.Component;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.update.ServerComponentUpdate;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.TabPane;
import nextapp.echo.extras.webcontainer.CommonResources;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ResourceRegistry;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;
import nextapp.echo.webcontainer.util.ArrayIterator;
import nextapp.echo.webcontainer.util.MultiIterator;

public class TabPanePeer
extends AbstractComponentSynchronizePeer {
    private static final String PROPERTY_ACTIVE_TAB_ID = "activeTabId";
    private static final Service TAB_PANE_SERVICE = JavaScriptService.forResources((String)"EchoExtras.TabPane", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.TabPane.js", "nextapp/echo/extras/webcontainer/resource/Sync.TabPane.js"});

    public TabPanePeer() {
        this.addOutputProperty(PROPERTY_ACTIVE_TAB_ID);
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("tabSelect", "tabSelectionListeners", String.class){

            public boolean hasListeners(Context context, Component component) {
                return ((TabPane)component).hasTabSelectionListeners();
            }

            public void processEvent(Context context, Component component, Object eventData) {
                TabPane tabPane = (TabPane)component;
                Integer tabIndex = TabPanePeer.this.getTabIndex(context, tabPane, (String)eventData);
                ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(class$nextapp$echo$app$update$ClientUpdateManager == null ? (class$nextapp$echo$app$update$ClientUpdateManager = TabPanePeer.class$("nextapp.echo.app.update.ClientUpdateManager")) : class$nextapp$echo$app$update$ClientUpdateManager);
                clientUpdateManager.setComponentAction(component, "tabSelect", (Object)tabIndex);
            }
        });
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("tabClose", "tabCloseEnabled", String.class){

            public boolean hasListeners(Context context, Component component) {
                return (Boolean)component.getRenderProperty("tabCloseEnabled", (Object)Boolean.FALSE);
            }

            public void processEvent(Context context, Component component, Object eventData) {
                TabPane tabPane = (TabPane)component;
                Integer tabIndex = TabPanePeer.this.getTabIndex(context, tabPane, (String)eventData);
                ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(class$nextapp$echo$app$update$ClientUpdateManager == null ? (class$nextapp$echo$app$update$ClientUpdateManager = TabPanePeer.class$("nextapp.echo.app.update.ClientUpdateManager")) : class$nextapp$echo$app$update$ClientUpdateManager);
                clientUpdateManager.setComponentAction(component, "tabClose", (Object)tabIndex);
            }
        });
    }

    public String getClientComponentType(boolean mode) {
        return "Extras.TabPane";
    }

    public Class getComponentClass() {
        return TabPane.class;
    }

    public Class getInputPropertyClass(String propertyName) {
        if (PROPERTY_ACTIVE_TAB_ID.equals(propertyName)) {
            return String.class;
        }
        return super.getInputPropertyClass(propertyName);
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if (PROPERTY_ACTIVE_TAB_ID.equals(propertyName)) {
            TabPane tabPane = (TabPane)component;
            int componentCount = tabPane.getVisibleComponentCount();
            if (componentCount == 0) {
                return null;
            }
            int activeTabIndex = tabPane.getActiveTabIndex();
            Component activeTab = activeTabIndex == -1 ? tabPane.getVisibleComponent(0) : (activeTabIndex < componentCount ? tabPane.getVisibleComponent(activeTabIndex) : tabPane.getVisibleComponent(componentCount - 1));
            UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
            return userInstance.getClientRenderId(activeTab);
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    private Integer getTabIndex(Context context, TabPane tabPane, String clientRenderId) {
        UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
        Component[] children = tabPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!userInstance.getClientRenderId(children[i]).equals(clientRenderId)) continue;
            return new Integer(i);
        }
        return null;
    }

    public Iterator getUpdatedOutputPropertyNames(Context context, Component component, ServerComponentUpdate update) {
        Iterator normalPropertyIterator = super.getUpdatedOutputPropertyNames(context, component, update);
        if (update.hasUpdatedProperty("activeTabIndex") || update.hasAddedChildren() || update.hasRemovedChildren()) {
            return new MultiIterator(new Iterator[]{normalPropertyIterator, new ArrayIterator((Object[])new String[]{PROPERTY_ACTIVE_TAB_ID})});
        }
        return normalPropertyIterator;
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(TAB_PANE_SERVICE.getId());
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int index, Object newValue) {
        if (PROPERTY_ACTIVE_TAB_ID.equals(propertyName)) {
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, "activeTabIndex", (Object)this.getTabIndex(context, (TabPane)component, (String)newValue));
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(TAB_PANE_SERVICE);
        CommonResources.install();
        ResourceRegistry resources = WebContainerServlet.getResourceRegistry();
        resources.add("Extras", "image/tabpane/Close.gif", ContentType.IMAGE_GIF);
        resources.add("Extras", "image/tabpane/Previous.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/tabpane/Next.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/tabpane/PreviousRollover.png", ContentType.IMAGE_PNG);
        resources.add("Extras", "image/tabpane/NextRollover.png", ContentType.IMAGE_PNG);
    }
}

