/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.sync.component;

import java.util.HashSet;
import java.util.Iterator;
import nextapp.echo.app.Component;
import nextapp.echo.app.Table;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.update.ServerComponentUpdate;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;
import nextapp.echo.webcontainer.sync.component.ListSelectionUtil;
import nextapp.echo.webcontainer.util.MultiIterator;

public class TablePeer
extends AbstractComponentSynchronizePeer {
    private static final Service TABLE_SERVICE = JavaScriptService.forResource("Echo.RemoteTable", "nextapp/echo/webcontainer/resource/Sync.RemoteTable.js");
    private static final String PROPERTY_COLUMN_COUNT = "columnCount";
    private static final String PROPERTY_COLUMN_WIDTH = "columnWidth";
    private static final String PROPERTY_HEADER_VISIBLE = "headerVisible";
    private static final String PROPERTY_ROW_COUNT = "rowCount";
    private static final String PROPERTY_SELECTION = "selection";
    private static final String PROPERTY_SELECTION_MODE = "selectionMode";

    public TablePeer() {
        this.addOutputProperty(PROPERTY_COLUMN_COUNT);
        this.addOutputProperty(PROPERTY_COLUMN_WIDTH, true);
        this.addOutputProperty(PROPERTY_HEADER_VISIBLE);
        this.addOutputProperty(PROPERTY_ROW_COUNT);
        this.addOutputProperty(PROPERTY_SELECTION);
        this.addOutputProperty(PROPERTY_SELECTION_MODE);
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("action", "actionListeners"){

            public boolean hasListeners(Context context, Component component) {
                return ((Table)component).hasActionListeners();
            }
        });
    }

    public String getClientComponentType(boolean mode) {
        return mode ? "RT" : "RemoteTable";
    }

    public Class getComponentClass() {
        return Table.class;
    }

    public Class getInputPropertyClass(String propertyName) {
        if (PROPERTY_SELECTION.equals(propertyName)) {
            return String.class;
        }
        return super.getInputPropertyClass(propertyName);
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        Table table = (Table)component;
        if (PROPERTY_COLUMN_COUNT.equals(propertyName)) {
            return new Integer(table.getModel().getColumnCount());
        }
        if (PROPERTY_COLUMN_WIDTH.equals(propertyName)) {
            return table.getColumnModel().getColumn(propertyIndex).getWidth();
        }
        if (PROPERTY_HEADER_VISIBLE.equals(propertyName)) {
            return table.isHeaderVisible();
        }
        if (PROPERTY_ROW_COUNT.equals(propertyName)) {
            return new Integer(table.getModel().getRowCount());
        }
        if (PROPERTY_SELECTION.equals(propertyName)) {
            return ListSelectionUtil.toString(table.getSelectionModel(), table.getModel().getRowCount());
        }
        if (PROPERTY_SELECTION_MODE.equals(propertyName)) {
            return new Integer(table.getSelectionModel().getSelectionMode());
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public Iterator getOutputPropertyIndices(Context context, Component component, String propertyName) {
        if (PROPERTY_COLUMN_WIDTH.equals(propertyName)) {
            final Iterator columnIterator = ((Table)component).getColumnModel().getColumns();
            return new Iterator(){
                private int i = 0;

                public boolean hasNext() {
                    return columnIterator.hasNext();
                }

                public Object next() {
                    columnIterator.next();
                    return new Integer(this.i++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return super.getOutputPropertyIndices(context, component, propertyName);
    }

    public Iterator getUpdatedOutputPropertyNames(Context context, Component component, ServerComponentUpdate update) {
        Iterator normalPropertyIterator = super.getUpdatedOutputPropertyNames(context, component, update);
        HashSet<String> additionalPropertyNames = new HashSet<String>();
        if (update.hasUpdatedProperty("model") || update.hasAddedChildren() || update.hasRemovedChildren()) {
            additionalPropertyNames.add(PROPERTY_ROW_COUNT);
            additionalPropertyNames.add(PROPERTY_COLUMN_COUNT);
        }
        if (update.hasUpdatedProperty(PROPERTY_SELECTION)) {
            additionalPropertyNames.add(PROPERTY_SELECTION_MODE);
        }
        return additionalPropertyNames.size() == 0 ? normalPropertyIterator : new MultiIterator(new Iterator[]{normalPropertyIterator, additionalPropertyNames.iterator()});
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(TABLE_SERVICE.getId());
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int index, Object newValue) {
        if (PROPERTY_SELECTION.equals(propertyName)) {
            int[] selection = ListSelectionUtil.toIntArray((String)newValue);
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, PROPERTY_SELECTION, (Object)selection);
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(TABLE_SERVICE);
    }
}

