/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.claims;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.util.DateUtils;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtils;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import net.minidev.json.JSONObject;

public abstract class ClaimsSet {
    private final JSONObject claims;

    protected ClaimsSet() {
        this.claims = new JSONObject();
    }

    protected ClaimsSet(JSONObject jsonObject) {
        if (jsonObject == null) {
            throw new IllegalArgumentException("The JSON object must not be null");
        }
        this.claims = jsonObject;
    }

    public void putAll(ClaimsSet other) {
        this.putAll((Map<String, Object>)other.claims);
    }

    public void putAll(Map<String, Object> claims) {
        this.claims.putAll(claims);
    }

    public Object getClaim(String name) {
        return this.claims.get((Object)name);
    }

    public <T> T getClaim(String name, Class<T> clazz) {
        try {
            return JSONObjectUtils.getGeneric(this.claims, name, clazz);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public <T> Map<LangTag, T> getLangTaggedClaim(String name, Class<T> clazz) {
        Map matches = LangTagUtils.find((String)name, (Map)this.claims);
        HashMap<LangTag, T> out = new HashMap<LangTag, T>();
        for (Map.Entry entry : matches.entrySet()) {
            LangTag langTag = (LangTag)entry.getKey();
            String compositeKey = name + (langTag != null ? "#" + langTag : "");
            try {
                out.put(langTag, JSONObjectUtils.getGeneric(this.claims, compositeKey, clazz));
            }
            catch (ParseException parseException) {}
        }
        return out;
    }

    public void setClaim(String name, Object value) {
        if (value != null) {
            this.claims.put((Object)name, value);
        } else {
            this.claims.remove((Object)name);
        }
    }

    public void setClaim(String name, Object value, LangTag langTag) {
        String keyName = langTag != null ? name + "#" + langTag : name;
        this.setClaim(keyName, value);
    }

    public String getStringClaim(String name) {
        try {
            return JSONObjectUtils.getString(this.claims, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getStringClaim(String name, LangTag langTag) {
        return langTag == null ? this.getStringClaim(name) : this.getStringClaim(name + '#' + langTag);
    }

    public Boolean getBooleanClaim(String name) {
        try {
            return JSONObjectUtils.getBoolean(this.claims, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Number getNumberClaim(String name) {
        try {
            return JSONObjectUtils.getNumber(this.claims, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public URL getURLClaim(String name) {
        try {
            return JSONObjectUtils.getURL(this.claims, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setURLClaim(String name, URL value) {
        if (value != null) {
            this.setClaim(name, value.toString());
        } else {
            this.claims.remove((Object)name);
        }
    }

    public URI getURIClaim(String name) {
        try {
            return JSONObjectUtils.getURI(this.claims, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setURIClaim(String name, URI value) {
        if (value != null) {
            this.setClaim(name, value.toString());
        } else {
            this.claims.remove((Object)name);
        }
    }

    public InternetAddress getEmailClaim(String name) {
        try {
            return JSONObjectUtils.getEmail(this.claims, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setEmailClaim(String name, InternetAddress value) {
        if (value != null) {
            this.setClaim(name, value.getAddress());
        } else {
            this.claims.remove((Object)name);
        }
    }

    public Date getDateClaim(String name) {
        try {
            return DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getNumber(this.claims, name).longValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setDateClaim(String name, Date value) {
        if (value != null) {
            this.setClaim(name, DateUtils.toSecondsSinceEpoch((Date)value));
        } else {
            this.claims.remove((Object)name);
        }
    }

    public List<String> getStringListClaim(String name) {
        try {
            return Arrays.asList(JSONObjectUtils.getStringArray(this.claims, name));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        return this.claims;
    }

    public JWTClaimsSet toJWTClaimsSet() throws ParseException {
        try {
            return JWTClaimsSet.parse((JSONObject)this.claims);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }
}

