/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.xmlutils;

import com.nitorcreations.xmlutils.IterableNodeList;
import com.nitorcreations.xmlutils.XPathQuery;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    public static final XPathQuery POM_PROPERTIES = new XPathQuery("//properties/*", "name()", "text()");
    public static final XPathQuery JAVA_UTIL_PROPERTIES = new XPathQuery("//entry[@key]", "@key", "text()");
    private static final XPathFactory factory = XPathFactory.newInstance();
    private static final Logger logger = Logger.getLogger(XMLUtil.class.getName());
    private static DOMImplementationRegistry registry;
    private static DOMImplementationLS impl;
    private static TransformerFactory tFactory;

    public static IterableNodeList runXPath(String expression, Node context) {
        XPath xpath = factory.newXPath();
        IterableNodeList ret = null;
        try {
            ret = new IterableNodeList((NodeList)xpath.evaluate(expression, context, XPathConstants.NODESET));
        }
        catch (XPathExpressionException e) {
            logger.log(Level.FINE, "Invalid XPath expression", e);
        }
        return ret;
    }

    public static String runSingleValueXPath(String expression, Node context) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String ret = null;
        try {
            ret = xpath.evaluate(expression, context);
        }
        catch (XPathExpressionException e) {
            logger.log(Level.FINE, "Invalid XPath expression", e);
        }
        return ret;
    }

    public static Object runXPath(String xpathExpressionString, Node contextNode, QName returnType) {
        XPath xpath = factory.newXPath();
        Object ret = null;
        try {
            XPathExpression xpathExpression = xpath.compile(xpathExpressionString);
            ret = xpathExpression.evaluate(contextNode, returnType);
        }
        catch (XPathExpressionException e) {
            logger.log(Level.FINE, "Invalid XPath expression", e);
        }
        return ret;
    }

    public static boolean runBooleanXPath(String expression, Node context) {
        Object object = XMLUtil.runXPath(expression, context, XPathConstants.BOOLEAN);
        boolean result = false;
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            result = b;
        }
        return result;
    }

    public static Number runNumericXPath(String expression, Node context) {
        Object object = XMLUtil.runXPath(expression, context, XPathConstants.NUMBER);
        Number result = null;
        if (object instanceof Number) {
            result = (Number)object;
        }
        return result;
    }

    public static String getAttribute(Node node, String attrName) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return "";
        }
        Node attr = attributes.getNamedItem(attrName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return "";
    }

    public static Document parseDocument(File xml) {
        try {
            FileInputStream in = new FileInputStream(xml);
            return XMLUtil.parseDocument(in);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.FINE, "XML File not found", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDocument(InputStream in) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            dbf.setValidating(false);
            dbf.setCoalescing(true);
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
            db.setEntityResolver(new DummyEntityResolver());
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    logger.log(Level.FINE, "XML parsing failed", e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    logger.log(Level.FINE, "XML parsing failed", e);
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    logger.log(Level.FINE, "XML parsing failed", e);
                }
            });
            doc = db.parse(new InputSource(in));
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.FINE, "XML parsing configuration error", e);
        }
        catch (SAXException e) {
            logger.log(Level.FINE, "XML parsing failed", e);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Unable to read XML file", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Unable to close XML file", e);
                }
            }
        }
        return doc;
    }

    public static Document emptyDocument() {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            dbf.setValidating(false);
            dbf.setCoalescing(true);
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.FINE, "XML parsing configuration error", e);
        }
        return doc;
    }

    public static String documentToString(Document doc) {
        if (doc == null) {
            return "null";
        }
        LSSerializer writer = impl.createLSSerializer();
        writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        return writer.writeToString(doc);
    }

    public static void writeDocument(Document doc, File file) {
        if (doc == null) {
            return;
        }
        LSSerializer writer = impl.createLSSerializer();
        writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        writer.writeToURI(doc, file.toURI().toString());
    }

    public static void writeDocument(Document doc, OutputStream out) {
        XMLUtil.writeDocument(doc, out, "utf-8");
    }

    public static void writeDocument(Document doc, OutputStream out, String encoding) {
        if (doc == null) {
            return;
        }
        LSSerializer writer = impl.createLSSerializer();
        writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        LSOutput lsOutput = impl.createLSOutput();
        lsOutput.setByteStream(out);
        lsOutput.setEncoding(encoding);
        writer.write(doc, lsOutput);
    }

    public static String getNodeText(Node cell) {
        Document temp = XMLUtil.parseDocument("<t/>");
        IterableNodeList list = new IterableNodeList(cell.getChildNodes());
        for (Node next : list) {
            Node imNode = temp.importNode(next, true);
            temp.getDocumentElement().appendChild(imNode);
        }
        String ret = XMLUtil.documentToString(temp);
        return ret.substring(ret.indexOf("\n") + 4, ret.length() - 6);
    }

    public static Document getXHTMLDocument() {
        String template = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">\n<head/><body/></html>";
        return XMLUtil.parseDocument(template);
    }

    public static Document getRssDocument() {
        String template = "<?xml version='1.0'?>\n<rss version=\"2.0\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\"/>";
        return XMLUtil.parseDocument(template);
    }

    public static Element getOrCreateChild(Element node, String nodeName) {
        return XMLUtil.getOrCreateChild(node, nodeName, nodeName);
    }

    public static Element getOrCreateChild(Element node, String nodeName, String xPath) {
        IterableNodeList children = XMLUtil.runXPath(xPath, node);
        if (children.length() > 0) {
            return (Element)children.item(0);
        }
        Element newChild = node.getOwnerDocument().createElement(nodeName);
        node.appendChild(newChild);
        return newChild;
    }

    public static void setElementText(Element node, String text) {
        Text textNode = node.getOwnerDocument().createTextNode(text);
        for (Node next : new IterableNodeList(node.getChildNodes())) {
            node.removeChild(next);
        }
        node.appendChild(textNode);
    }

    public static Document getPomDocument() {
        String template = "<?xml version=\"1.0\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"\n xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion><groupId/><artifactId/><version/><packaging/><properties/>\n</project>";
        return XMLUtil.parseDocument(template);
    }

    public static Document parseDocument(String template) {
        try {
            return XMLUtil.parseDocument(new ByteArrayInputStream(template.getBytes("utf-8")));
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.FINE, "utf-8 not supported - WHAAAT?", e);
            return null;
        }
    }

    public static Map<String, String> parseXMLXPathProperties(File xml, XPathQuery query) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> empty = new LinkedHashMap<String, String>();
        Document doc = XMLUtil.parseDocument(xml);
        IterableNodeList nodeList = XMLUtil.runXPath(query.getParamXpath(), doc.getDocumentElement());
        for (Node node : nodeList) {
            String key = XMLUtil.runSingleValueXPath(query.getKeyXpath(), node);
            String value = XMLUtil.runSingleValueXPath(query.getValueXpath(), node);
            if (key == null || key.trim().length() <= 0) continue;
            if (value == null || value.trim().length() == 0) {
                empty.put(key, "");
                continue;
            }
            ret.put(key, value);
        }
        if (ret.size() > 0 && empty.size() > 0) {
            for (String string : ret.keySet()) {
                empty.remove(string);
            }
            ret.putAll(empty);
        }
        return ret;
    }

    private static Transformer newTransformer(Document source) {
        DOMSource tSource = new DOMSource(source, "");
        try {
            Templates tmpls = tFactory.newTemplates(tSource);
            Transformer ret = tmpls.newTransformer();
            return ret;
        }
        catch (TransformerConfigurationException e) {
            return null;
        }
    }

    public static Node transform(Node xml, Document xsl, Map<String, String> properties) {
        Transformer t = XMLUtil.newTransformer(xsl);
        for (Map.Entry<String, String> next : properties.entrySet()) {
            t.setParameter(next.getKey(), next.getValue());
        }
        try {
            DocumentFragment out = XMLUtil.emptyDocument().createDocumentFragment();
            DOMResult r = new DOMResult(out);
            t.transform(new DOMSource(xml), r);
            return out.getFirstChild();
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public static Node transform(File xml, Document xsl, Map<String, String> properties) {
        Transformer t = XMLUtil.newTransformer(xsl);
        for (Map.Entry<String, String> next : properties.entrySet()) {
            t.setParameter(next.getKey(), next.getValue());
        }
        try {
            DocumentFragment out = XMLUtil.emptyDocument().createDocumentFragment();
            DOMResult r = new DOMResult(out);
            t.transform(new StreamSource(xml), r);
            return out.getFirstChild();
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public static String transformToString(Node xml, Document xsl, Map<String, String> properties) {
        Transformer t = XMLUtil.newTransformer(xsl);
        t.setOutputProperty("method", "text");
        for (Map.Entry<String, String> next : properties.entrySet()) {
            t.setParameter(next.getKey(), next.getValue());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult r = new StreamResult(out);
        try {
            t.transform(new DOMSource(xml), r);
            return out.toString();
        }
        catch (TransformerException e) {
            return null;
        }
    }

    static {
        tFactory = TransformerFactory.newInstance();
        try {
            registry = DOMImplementationRegistry.newInstance();
            impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static final class DummyEntityResolver
    implements EntityResolver {
        private DummyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
            return new InputSource(new StringReader(""));
        }
    }
}

