/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.controls;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.ldap.client.Debug;

public class LDAPPagedResultsControl
extends LDAPControl {
    private static String requestOID = "1.2.840.113556.1.4.319";
    private static String responseOID = "1.2.840.113556.1.4.319";
    private static final byte[] EMPTY_COOKIE = new byte[0];
    private int pageSize;
    private byte[] Cookie;

    public LDAPPagedResultsControl(int pagesize, byte[] cookie, boolean critical) {
        super(requestOID, critical, null);
        this.pageSize = pagesize;
        this.Cookie = cookie;
        this.setEncodedValue();
    }

    private void setEncodedValue() {
        ASN1Sequence m_prRequest = new ASN1Sequence();
        m_prRequest.add(new ASN1Integer(this.pageSize));
        m_prRequest.add(new ASN1OctetString(this.Cookie == null ? EMPTY_COOKIE : this.Cookie));
        this.setValue(m_prRequest.getEncoding(new LBEREncoder()));
    }

    public LDAPPagedResultsControl(int pageSize, boolean critical) {
        this(pageSize, null, critical);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pagesize) {
        this.pageSize = pagesize;
        this.setEncodedValue();
    }

    public byte[] getCookie() {
        return this.Cookie;
    }

    public void setCookie(byte[] cookie) {
        this.Cookie = cookie;
        this.setEncodedValue();
    }

    static {
        try {
            LDAPControl.register(responseOID, Class.forName("com.novell.ldap.controls.LDAPPagedResultsResponse"));
            Debug.trace("Controls", "Registered Paged Results Control Response Class");
        }
        catch (ClassNotFoundException e) {
            Debug.trace("Controls", "Could not register Paged Results Control Response - Class not found");
        }
    }
}

