/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class GetBindDNResponse
extends LDAPExtendedResponse {
    private String identity;

    public GetBindDNResponse(RfcLDAPMessage rfcMessage) throws IOException {
        super(rfcMessage);
        if (this.getResultCode() == 0) {
            byte[] returnedValue = this.getValue();
            if (returnedValue == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder decoder = new LBERDecoder();
            if (decoder == null) {
                throw new IOException("Decoding error");
            }
            ASN1OctetString asn1_identity = (ASN1OctetString)decoder.decode(returnedValue);
            if (asn1_identity == null) {
                throw new IOException("Decoding error");
            }
            this.identity = asn1_identity.stringValue();
            if (this.identity == null) {
                throw new IOException("Decoding error");
            }
        } else {
            this.identity = "";
        }
    }

    public String getIdentity() {
        return this.identity;
    }
}

