/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.DirectiveList;
import com.novell.sasl.client.ParsedDirective;
import com.novell.sasl.client.TokenParser;
import com.novell.security.sasl.SaslException;
import java.util.ArrayList;
import java.util.Iterator;

class DigestChallenge {
    public static final int QOP_AUTH = 1;
    public static final int QOP_AUTH_INT = 2;
    public static final int QOP_AUTH_CONF = 4;
    public static final int QOP_UNRECOGNIZED = 8;
    private static final int CIPHER_3DES = 1;
    private static final int CIPHER_DES = 2;
    private static final int CIPHER_RC4_40 = 4;
    private static final int CIPHER_RC4 = 8;
    private static final int CIPHER_RC4_56 = 16;
    private static final int CIPHER_UNRECOGNIZED = 32;
    private static final int CIPHER_RECOGNIZED_MASK = 31;
    private ArrayList m_realms = new ArrayList(5);
    private String m_nonce = null;
    private int m_qop = 0;
    private boolean m_staleFlag = false;
    private int m_maxBuf = -1;
    private String m_characterSet = null;
    private String m_algorithm = null;
    private int m_cipherOptions = 0;

    DigestChallenge(byte[] challenge) throws SaslException {
        DirectiveList dirList = new DirectiveList(challenge);
        try {
            dirList.parseDirectives();
            this.checkSemantics(dirList);
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    void checkSemantics(DirectiveList dirList) throws SaslException {
        Iterator directives = dirList.getIterator();
        while (directives.hasNext()) {
            ParsedDirective directive = (ParsedDirective)directives.next();
            String name = directive.getName();
            if (name.equals("realm")) {
                this.handleRealm(directive);
                continue;
            }
            if (name.equals("nonce")) {
                this.handleNonce(directive);
                continue;
            }
            if (name.equals("qop")) {
                this.handleQop(directive);
                continue;
            }
            if (name.equals("maxbuf")) {
                this.handleMaxbuf(directive);
                continue;
            }
            if (name.equals("charset")) {
                this.handleCharset(directive);
                continue;
            }
            if (name.equals("algorithm")) {
                this.handleAlgorithm(directive);
                continue;
            }
            if (name.equals("cipher")) {
                this.handleCipher(directive);
                continue;
            }
            if (!name.equals("stale")) continue;
            this.handleStale(directive);
        }
        if (-1 == this.m_maxBuf) {
            this.m_maxBuf = 65536;
        }
        if (this.m_qop == 0) {
            this.m_qop = 1;
        } else {
            if ((this.m_qop & 1) != 1) {
                throw new SaslException("Only qop-auth is supported by client");
            }
            if ((this.m_qop & 4) == 4 && 0 == (this.m_cipherOptions & 0x1F)) {
                throw new SaslException("Invalid cipher options");
            }
            if (null == this.m_nonce) {
                throw new SaslException("Missing nonce directive");
            }
            if (this.m_staleFlag) {
                throw new SaslException("Unexpected stale flag");
            }
            if (null == this.m_algorithm) {
                throw new SaslException("Missing algorithm directive");
            }
        }
    }

    void handleNonce(ParsedDirective pd) throws SaslException {
        if (null != this.m_nonce) {
            throw new SaslException("Too many nonce values.");
        }
        this.m_nonce = pd.getValue();
    }

    void handleRealm(ParsedDirective pd) {
        this.m_realms.add(pd.getValue());
    }

    void handleQop(ParsedDirective pd) throws SaslException {
        if (this.m_qop != 0) {
            throw new SaslException("Too many qop directives.");
        }
        TokenParser parser = new TokenParser(pd.getValue());
        String token = parser.parseToken();
        while (token != null) {
            this.m_qop = token.equals("auth") ? (this.m_qop |= 1) : (token.equals("auth-int") ? (this.m_qop |= 2) : (token.equals("auth-conf") ? (this.m_qop |= 4) : (this.m_qop |= 8)));
            token = parser.parseToken();
        }
    }

    void handleMaxbuf(ParsedDirective pd) throws SaslException {
        if (-1 != this.m_maxBuf) {
            throw new SaslException("Too many maxBuf directives.");
        }
        this.m_maxBuf = Integer.parseInt(pd.getValue());
        if (0 == this.m_maxBuf) {
            throw new SaslException("Max buf value must be greater than zero.");
        }
    }

    void handleCharset(ParsedDirective pd) throws SaslException {
        if (null != this.m_characterSet) {
            throw new SaslException("Too many charset directives.");
        }
        this.m_characterSet = pd.getValue();
        if (!this.m_characterSet.equals("utf-8")) {
            throw new SaslException("Invalid character encoding directive");
        }
    }

    void handleAlgorithm(ParsedDirective pd) throws SaslException {
        if (null != this.m_algorithm) {
            throw new SaslException("Too many algorithm directives.");
        }
        this.m_algorithm = pd.getValue();
        if (!"md5-sess".equals(this.m_algorithm)) {
            throw new SaslException("Invalid algorithm directive value: " + this.m_algorithm);
        }
    }

    void handleCipher(ParsedDirective pd) throws SaslException {
        if (0 != this.m_cipherOptions) {
            throw new SaslException("Too many cipher directives.");
        }
        TokenParser parser = new TokenParser(pd.getValue());
        String token = parser.parseToken();
        token = parser.parseToken();
        while (token != null) {
            this.m_cipherOptions = "3des".equals(token) ? (this.m_cipherOptions |= 1) : ("des".equals(token) ? (this.m_cipherOptions |= 2) : ("rc4-40".equals(token) ? (this.m_cipherOptions |= 4) : ("rc4".equals(token) ? (this.m_cipherOptions |= 8) : ("rc4-56".equals(token) ? (this.m_cipherOptions |= 0x10) : (this.m_cipherOptions |= 0x20)))));
            token = parser.parseToken();
        }
        if (this.m_cipherOptions == 0) {
            this.m_cipherOptions = 32;
        }
    }

    void handleStale(ParsedDirective pd) throws SaslException {
        if (this.m_staleFlag) {
            throw new SaslException("Too many stale directives.");
        }
        if (!"true".equals(pd.getValue())) {
            throw new SaslException("Invalid stale directive value: " + pd.getValue());
        }
        this.m_staleFlag = true;
    }

    public ArrayList getRealms() {
        return this.m_realms;
    }

    public String getNonce() {
        return this.m_nonce;
    }

    public int getQop() {
        return this.m_qop;
    }

    public boolean getStaleFlag() {
        return this.m_staleFlag;
    }

    public int getMaxBuf() {
        return this.m_maxBuf;
    }

    public String getCharacterSet() {
        return this.m_characterSet;
    }

    public String getAlgorithm() {
        return this.m_algorithm;
    }

    public int getCipherOptions() {
        return this.m_cipherOptions;
    }
}

