/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry.backoff;

import com.nurkiewicz.asyncretry.RetryContext;
import com.nurkiewicz.asyncretry.backoff.Backoff;

public class ExponentialDelayBackoff
implements Backoff {
    private final long initialDelayMillis;
    private final double multiplier;

    public ExponentialDelayBackoff(long initialDelayMillis, double multiplier) {
        if (initialDelayMillis <= 0L) {
            throw new IllegalArgumentException("Initial delay must be positive but was: " + initialDelayMillis);
        }
        this.initialDelayMillis = initialDelayMillis;
        this.multiplier = multiplier;
    }

    @Override
    public long delayMillis(RetryContext context) {
        return (long)((double)this.initialDelayMillis * Math.pow(this.multiplier, context.getRetryCount() - 1));
    }
}

