/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry.backoff;

import com.nurkiewicz.asyncretry.backoff.Backoff;
import com.nurkiewicz.asyncretry.backoff.RandomBackoff;
import java.util.Random;

public class ProportionalRandomBackoff
extends RandomBackoff {
    public static final double DEFAULT_MULTIPLIER = 0.1;
    private final double multiplier;

    public ProportionalRandomBackoff(Backoff target) {
        this(target, 0.1);
    }

    public ProportionalRandomBackoff(Backoff target, Random random) {
        this(target, 0.1, random);
    }

    public ProportionalRandomBackoff(Backoff target, double multiplier) {
        super(target);
        this.multiplier = multiplier;
    }

    public ProportionalRandomBackoff(Backoff target, double multiplier, Random random) {
        super(target, random);
        this.multiplier = multiplier;
    }

    @Override
    long addRandomJitter(long initialDelay) {
        double randomMultiplier = (1.0 - 2.0 * this.random().nextDouble()) * this.multiplier;
        return (long)((double)initialDelay * (1.0 + randomMultiplier));
    }
}

