/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry.backoff;

import com.google.common.base.Throwables;
import com.nurkiewicz.asyncretry.RetryContext;
import com.nurkiewicz.asyncretry.backoff.Backoff;
import com.nurkiewicz.asyncretry.backoff.BackoffWrapper;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;

public abstract class RandomBackoff
extends BackoffWrapper {
    private final Callable<Random> randomSource;

    protected RandomBackoff(Backoff target) {
        this(target, new Callable<Random>(){

            @Override
            public Random call() throws Exception {
                return ThreadLocalRandom.current();
            }
        });
    }

    protected RandomBackoff(Backoff target, final Random randomSource) {
        this(target, new Callable<Random>(){

            @Override
            public Random call() throws Exception {
                return randomSource;
            }
        });
    }

    private RandomBackoff(Backoff target, Callable<Random> randomSource) {
        super(target);
        this.randomSource = randomSource;
    }

    @Override
    public long delayMillis(RetryContext context) {
        long initialDelay = this.target.delayMillis(context);
        long randomDelay = this.addRandomJitter(initialDelay);
        return Math.max(randomDelay, 0L);
    }

    abstract long addRandomJitter(long var1);

    protected Random random() {
        try {
            return this.randomSource.call();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

