/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry.backoff;

import com.nurkiewicz.asyncretry.backoff.Backoff;
import com.nurkiewicz.asyncretry.backoff.RandomBackoff;
import java.util.Random;

public class UniformRandomBackoff
extends RandomBackoff {
    public static final long DEFAULT_RANDOM_RANGE_MILLIS = 100L;
    private final long range;

    public UniformRandomBackoff(Backoff target) {
        this(target, 100L);
    }

    public UniformRandomBackoff(Backoff target, Random random) {
        this(target, 100L, random);
    }

    public UniformRandomBackoff(Backoff target, long range) {
        super(target);
        this.range = range;
    }

    public UniformRandomBackoff(Backoff target, long range, Random random) {
        super(target, random);
        this.range = range;
    }

    @Override
    long addRandomJitter(long initialDelay) {
        double uniformRandom = (1.0 - this.random().nextDouble() * 2.0) * (double)this.range;
        return (long)((double)initialDelay + uniformRandom);
    }
}

