/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry.policy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.nurkiewicz.asyncretry.RetryContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RetryPolicy {
    public static final RetryPolicy DEFAULT = new RetryPolicy();
    private final int maxRetries;
    private final Set<Class<? extends Throwable>> retryOn;
    private final Set<Class<? extends Throwable>> abortOn;
    private final Predicate<Throwable> retryPredicate;
    private final Predicate<Throwable> abortPredicate;

    public RetryPolicy retryOn(Class<? extends Throwable> ... retryOnThrowables) {
        return new RetryPolicy(this.maxRetries, RetryPolicy.setPlusElems(this.retryOn, retryOnThrowables), this.abortOn, this.retryPredicate, this.abortPredicate);
    }

    public RetryPolicy abortOn(Class<? extends Throwable> ... abortOnThrowables) {
        return new RetryPolicy(this.maxRetries, this.retryOn, RetryPolicy.setPlusElems(this.abortOn, abortOnThrowables), this.retryPredicate, this.abortPredicate);
    }

    public RetryPolicy abortIf(Predicate<Throwable> abortPredicate) {
        return new RetryPolicy(this.maxRetries, this.retryOn, this.abortOn, this.retryPredicate, (Predicate<Throwable>)Predicates.or(this.abortPredicate, abortPredicate));
    }

    public RetryPolicy retryIf(Predicate<Throwable> retryPredicate) {
        return new RetryPolicy(this.maxRetries, this.retryOn, this.abortOn, (Predicate<Throwable>)Predicates.or(this.retryPredicate, retryPredicate), this.abortPredicate);
    }

    public RetryPolicy dontRetry() {
        return new RetryPolicy(0, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate);
    }

    public RetryPolicy withMaxRetries(int times) {
        return new RetryPolicy(times, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate);
    }

    public RetryPolicy(int maxRetries, Set<Class<? extends Throwable>> retryOn, Set<Class<? extends Throwable>> abortOn, Predicate<Throwable> retryPredicate, Predicate<Throwable> abortPredicate) {
        this.maxRetries = maxRetries;
        this.retryOn = retryOn;
        this.abortOn = abortOn;
        this.retryPredicate = retryPredicate;
        this.abortPredicate = abortPredicate;
    }

    public RetryPolicy() {
        this(Integer.MAX_VALUE, Collections.emptySet(), Collections.emptySet(), (Predicate<Throwable>)Predicates.alwaysFalse(), (Predicate<Throwable>)Predicates.alwaysFalse());
    }

    public boolean shouldContinue(RetryContext context) {
        if (this.tooManyRetries(context)) {
            return false;
        }
        if (this.abortPredicate.apply((Object)context.getLastThrowable())) {
            return false;
        }
        if (this.retryPredicate.apply((Object)context.getLastThrowable())) {
            return true;
        }
        return this.exceptionClassRetryable(context);
    }

    private boolean tooManyRetries(RetryContext context) {
        return context.getRetryCount() > this.maxRetries;
    }

    private boolean exceptionClassRetryable(RetryContext context) {
        if (context.getLastThrowable() == null) {
            return false;
        }
        Class<?> e = context.getLastThrowable().getClass();
        if (this.abortOn.isEmpty()) {
            return RetryPolicy.matches(e, this.retryOn);
        }
        return !RetryPolicy.matches(e, this.abortOn) && RetryPolicy.matches(e, this.retryOn);
    }

    private static boolean matches(Class<? extends Throwable> throwable, Set<Class<? extends Throwable>> classSet) {
        if (classSet.isEmpty()) {
            return true;
        }
        for (Class<? extends Throwable> c : classSet) {
            if (!c.isAssignableFrom(throwable)) continue;
            return true;
        }
        return false;
    }

    private static <T> Set<T> setPlusElems(Set<T> initial, T ... newElement) {
        HashSet<T> copy = new HashSet<T>(initial);
        copy.addAll(Arrays.asList(newElement));
        return Collections.unmodifiableSet(copy);
    }
}

