/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase.filter;

import java.util.List;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.ParseConstants;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseFilterUtils {
    public static String toParseableString(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is null");
        }
        if (filter instanceof CompareFilter) {
            return HBaseFilterUtils.toParseableString((CompareFilter)filter);
        }
        if (filter instanceof SingleColumnValueFilter) {
            return HBaseFilterUtils.toParseableString((SingleColumnValueFilter)filter);
        }
        if (filter instanceof PageFilter) {
            return HBaseFilterUtils.toParseableString((PageFilter)filter);
        }
        if (filter instanceof ColumnCountGetFilter) {
            return HBaseFilterUtils.toParseableString((ColumnCountGetFilter)filter);
        }
        if (filter instanceof PrefixFilter) {
            return HBaseFilterUtils.toParseableString((PrefixFilter)filter);
        }
        if (filter instanceof FilterList) {
            return HBaseFilterUtils.toParseableString((FilterList)filter);
        }
        if (filter instanceof ColumnPaginationFilter) {
            return HBaseFilterUtils.toParseableString((ColumnPaginationFilter)filter);
        }
        if (filter instanceof SkipFilter) {
            return HBaseFilterUtils.toParseableString((SkipFilter)filter);
        }
        if (filter instanceof WhileMatchFilter) {
            return HBaseFilterUtils.toParseableString((WhileMatchFilter)filter);
        }
        throw new IllegalArgumentException("Invalid filter: " + filter);
    }

    private static String toParseableString(CompareFilter.CompareOp op) {
        if (op == null) {
            throw new IllegalArgumentException("Compare operator is null");
        }
        switch (op) {
            case LESS: {
                return Bytes.toString((byte[])ParseConstants.LESS_THAN_ARRAY);
            }
            case LESS_OR_EQUAL: {
                return Bytes.toString((byte[])ParseConstants.LESS_THAN_OR_EQUAL_TO_ARRAY);
            }
            case EQUAL: {
                return Bytes.toString((byte[])ParseConstants.EQUAL_TO_ARRAY);
            }
            case NOT_EQUAL: {
                return Bytes.toString((byte[])ParseConstants.NOT_EQUAL_TO_ARRAY);
            }
            case GREATER_OR_EQUAL: {
                return Bytes.toString((byte[])ParseConstants.GREATER_THAN_OR_EQUAL_TO_ARRAY);
            }
            case GREATER: {
                return Bytes.toString((byte[])ParseConstants.GREATER_THAN_ARRAY);
            }
        }
        throw new IllegalArgumentException("Invalid compare operator: " + op);
    }

    private static String toParseableString(WritableByteArrayComparable comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator is null");
        }
        StringBuilder sb = new StringBuilder();
        if (comparator instanceof BinaryComparator) {
            sb.append('\'').append(Bytes.toString((byte[])ParseConstants.binaryType)).append(':').append(Bytes.toString((byte[])comparator.getValue())).append('\'');
        } else if (comparator instanceof BinaryPrefixComparator) {
            sb.append('\'').append(Bytes.toString((byte[])ParseConstants.binaryPrefixType)).append(':').append(Bytes.toString((byte[])comparator.getValue())).append('\'');
        } else if (comparator instanceof RegexStringComparator) {
            sb.append('\'').append(Bytes.toString((byte[])ParseConstants.regexStringType)).append(':').append(Bytes.toString((byte[])comparator.getValue())).append('\'');
        } else if (comparator instanceof SubstringComparator) {
            sb.append('\'').append(Bytes.toString((byte[])ParseConstants.substringType)).append(':').append(Bytes.toString((byte[])comparator.getValue())).append('\'');
        } else {
            throw new IllegalArgumentException("This comparator has not been implemented " + comparator);
        }
        return sb.toString();
    }

    private static String toParseableString(CompareFilter filter) {
        return filter.getClass().getSimpleName() + '(' + HBaseFilterUtils.toParseableString(filter.getOperator()) + ',' + HBaseFilterUtils.toParseableString(filter.getComparator()) + ')';
    }

    private static String toParseableString(SingleColumnValueFilter filter) {
        return filter.getClass().getSimpleName() + "('" + Bytes.toString((byte[])filter.getFamily()) + "','" + Bytes.toString((byte[])filter.getQualifier()) + "'," + HBaseFilterUtils.toParseableString(filter.getOperator()) + ',' + HBaseFilterUtils.toParseableString(filter.getComparator()) + ',' + filter.getFilterIfMissing() + ',' + filter.getLatestVersionOnly() + ')';
    }

    private static String toParseableString(PageFilter filter) {
        return filter.getClass().getSimpleName() + '(' + filter.getPageSize() + ')';
    }

    private static String toParseableString(ColumnPaginationFilter filter) {
        return filter.getClass().getSimpleName() + '(' + filter.getLimit() + ',' + filter.getOffset() + ')';
    }

    private static String toParseableString(ColumnCountGetFilter filter) {
        return filter.getClass().getSimpleName() + '(' + filter.getLimit() + ')';
    }

    private static String toParseableString(PrefixFilter filter) {
        return filter.getClass().getSimpleName() + "('" + Bytes.toString((byte[])filter.getPrefix()) + "')";
    }

    private static String toParseableString(SkipFilter filter) {
        return "(" + Bytes.toString((byte[])ParseConstants.SKIP_ARRAY) + " " + HBaseFilterUtils.toParseableString(filter.getFilter()) + ")";
    }

    private static String toParseableString(WhileMatchFilter filter) {
        return "(" + Bytes.toString((byte[])ParseConstants.WHILE_ARRAY) + " " + HBaseFilterUtils.toParseableString(filter.getFilter()) + ")";
    }

    private static String toParseableString(FilterList filterList) {
        StringBuilder sb = new StringBuilder();
        List filters = filterList.getFilters();
        boolean isEmpty = true;
        for (int i = 0; i < filters.size(); ++i) {
            String filterString = HBaseFilterUtils.toParseableString((Filter)filters.get(i));
            if (filterString.isEmpty()) continue;
            if (isEmpty) {
                sb.append("(").append(filterString);
                isEmpty = false;
                continue;
            }
            sb.append(" ");
            if (filterList.getOperator().equals((Object)FilterList.Operator.MUST_PASS_ALL)) {
                sb.append(Bytes.toString((byte[])ParseConstants.AND));
            } else if (filterList.getOperator().equals((Object)FilterList.Operator.MUST_PASS_ONE)) {
                sb.append(Bytes.toString((byte[])ParseConstants.OR));
            } else {
                throw new IllegalArgumentException("Invalid FilterList: " + filterList);
            }
            sb.append(" ").append(filterString);
        }
        if (!isEmpty) {
            sb.append(")");
        }
        return sb.toString();
    }
}

