/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.batch;

import com.alipay.oceanbase.rpc.batch.QueryByBatchResultSet;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObHTableFilter;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.stream.QueryResultSet;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class QueryByBatch
implements TableQuery {
    private final TableQuery tableQuery;
    private Object[] start;
    private Object[] end;
    private boolean endEquals;
    private String[] keys = new String[0];
    private String[] select = new String[0];

    public QueryByBatch(TableQuery tableQuery) {
        this.tableQuery = tableQuery;
    }

    @Override
    public ObTableQuery getObTableQuery() {
        return this.tableQuery.getObTableQuery();
    }

    @Override
    public String getTableName() {
        return this.tableQuery.getTableName();
    }

    @Override
    public void setEntityType(ObTableEntityType entityType) {
        this.tableQuery.setEntityType(entityType);
    }

    @Override
    public ObTableEntityType getEntityType() {
        return this.tableQuery.getEntityType();
    }

    @Override
    public QueryResultSet execute() {
        return new QueryResultSet(new QueryByBatchResultSet(this));
    }

    @Override
    public QueryResultSet executeInit(ObPair<Long, ObTableParam> entry) throws Exception {
        throw new IllegalArgumentException("not support executeInit");
    }

    @Override
    public QueryResultSet executeNext(ObPair<Long, ObTableParam> entry) throws Exception {
        throw new IllegalArgumentException("not support executeNext");
    }

    @Override
    public TableQuery addScanRange(Object start, Object end) {
        this.addScanRange(start, true, end, true);
        return this;
    }

    @Override
    public TableQuery addScanRange(Object[] start, Object[] end) {
        return this.addScanRange(start, true, end, true);
    }

    @Override
    public TableQuery addScanRange(Object start, boolean startEquals, Object end, boolean endEquals) {
        this.addScanRange(new Object[]{start}, startEquals, new Object[]{end}, endEquals);
        return this;
    }

    @Override
    public TableQuery addScanRange(Object[] start, boolean startEquals, Object[] end, boolean endEquals) {
        this.start = start;
        this.end = end;
        this.endEquals = endEquals;
        this.tableQuery.addScanRange(start, startEquals, end, endEquals);
        return this;
    }

    @Override
    public TableQuery addScanRangeStartsWith(Object start) {
        this.addScanRangeStartsWith(new Object[]{start});
        return this;
    }

    @Override
    public TableQuery addScanRangeStartsWith(Object[] start) {
        this.addScanRangeStartsWith(start, true);
        return this;
    }

    @Override
    public TableQuery addScanRangeStartsWith(Object[] start, boolean startEquals) {
        this.start = start;
        this.tableQuery.addScanRangeStartsWith(start, startEquals);
        return this;
    }

    @Override
    public TableQuery addScanRangeEndsWith(Object end) {
        this.addScanRangeEndsWith(new Object[]{end});
        return this;
    }

    @Override
    public TableQuery addScanRangeEndsWith(Object[] end) {
        this.addScanRangeEndsWith(end, true);
        return this;
    }

    @Override
    public TableQuery addScanRangeEndsWith(Object[] end, boolean endEquals) {
        this.end = end;
        this.endEquals = endEquals;
        this.tableQuery.addScanRangeEndsWith(end, endEquals);
        return this;
    }

    @Override
    public TableQuery scanOrder(boolean forward) {
        throw new IllegalArgumentException("not support scanOrder for QueryByBatch");
    }

    @Override
    public TableQuery indexName(String indexName) {
        throw new IllegalArgumentException("not support indexName for QueryByBatch");
    }

    @Override
    public TableQuery primaryIndex() {
        throw new IllegalArgumentException("not support primaryIndex for QueryByBatch");
    }

    @Override
    public TableQuery filterString(String filterString) {
        throw new IllegalArgumentException("not support filterString for QueryByBatch");
    }

    @Override
    public TableQuery setFilter(ObTableFilter filter) {
        throw new IllegalArgumentException("not support construct filter string for " + this.getClass().toString());
    }

    @Override
    public TableQuery setHTableFilter(ObHTableFilter obHTableFilter) {
        throw new IllegalArgumentException("not support setHTableFilter for QueryByBatch");
    }

    @Override
    public QueryByBatch setBatchSize(int batchSize) {
        this.tableQuery.limit(batchSize);
        return this;
    }

    @Override
    public TableQuery setOperationTimeout(long operationTimeout) {
        this.tableQuery.setOperationTimeout(operationTimeout);
        return this;
    }

    @Override
    public TableQuery setMaxResultSize(long maxResultSize) {
        throw new IllegalArgumentException("not support setMaxResultSize");
    }

    @Override
    public TableQuery setScanRangeColumns(String ... columns) {
        this.getTableQuery().setScanRangeColumns(columns);
        return this;
    }

    @Override
    public void clear() {
        this.tableQuery.clear();
    }

    public TableQuery getTableQuery() {
        return this.tableQuery;
    }

    @Override
    public TableQuery setKeys(String ... keys) {
        this.keys = keys;
        this.mergeSelect();
        return this;
    }

    @Override
    public TableQuery limit(int limit) {
        throw new IllegalArgumentException("not support limit for QueryByBatch");
    }

    @Override
    public TableQuery limit(int offset, int limit) {
        throw new IllegalArgumentException("not support limit for QueryByBatch");
    }

    @Override
    public QueryByBatch select(String ... columns) {
        this.select = columns;
        this.mergeSelect();
        return this;
    }

    private void mergeSelect() {
        HashSet<String> keySet = new HashSet<String>(Arrays.asList(this.keys));
        HashSet<String> selectSet = new HashSet<String>(Arrays.asList(this.select));
        if (keySet.size() != this.keys.length || selectSet.size() != this.select.length) {
            throw new IllegalArgumentException("key duplicate in (keys or select)");
        }
        HashSet<String> mix = new HashSet<String>();
        mix.addAll(keySet);
        mix.addAll(selectSet);
        if (mix.size() == keySet.size() + selectSet.size()) {
            String[] mixSelect = new String[this.keys.length + this.select.length];
            System.arraycopy(this.keys, 0, mixSelect, 0, this.keys.length);
            System.arraycopy(this.select, 0, mixSelect, this.keys.length, this.select.length);
            this.tableQuery.select(mixSelect);
        } else if (mix.size() == selectSet.size()) {
            this.tableQuery.select(this.select);
        } else {
            throw new IllegalArgumentException("key duplicate in (keys and select)");
        }
    }

    public String[] getKeys() {
        return this.keys;
    }

    public Object[] getStart() {
        return this.start;
    }

    public Object[] getEnd() {
        return this.end;
    }

    public boolean isEndEquals() {
        return this.endEquals;
    }

    @Override
    public List<String> getSelectColumns() {
        throw new ObTableException("only query from BatchOperation getSelectColumns");
    }

    @Override
    public Row getRowKey() throws Exception {
        throw new ObTableException("only query from BatchOperation support row key");
    }

    @Override
    public TableQuery setRowKey(Row row) throws Exception {
        throw new ObTableException("only query from BatchOperation support row key");
    }
}

