/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.transport;

import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacket;
import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacketCode;
import com.alipay.oceanbase.rpc.protocol.packet.ObRpcPacket;
import com.alipay.oceanbase.rpc.protocol.packet.ObRpcPacketHeader;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableStreamRequest;
import com.alipay.oceanbase.rpc.threadlocal.ThreadLocalMap;
import com.alipay.oceanbase.rpc.util.ObPureCrc32C;
import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.ResponseStatus;
import java.net.InetSocketAddress;

public class ObPacketFactory
implements CommandFactory {
    boolean reRouting;

    public ObPacketFactory(boolean reRouting) {
        this.reRouting = reRouting;
    }

    public ObTablePacket createRequestCommand(Object requestObject) {
        if (requestObject instanceof ObPayload) {
            ObPayload request = (ObPayload)requestObject;
            ObTablePacket obRequest = new ObTablePacket();
            obRequest.setCmdCode(ObTablePacketCode.valueOf((short)request.getPcode()));
            obRequest.setId(request.getChannelId());
            obRequest.setPacketContent(this.encodePayload(request));
            return obRequest;
        }
        return null;
    }

    private byte[] encodePayload(ObPayload payload) {
        byte[] payloadContent = payload.encode();
        ObRpcPacketHeader rpcHeaderPacket = new ObRpcPacketHeader();
        rpcHeaderPacket.setPcode(payload.getPcode());
        if (this.reRouting) {
            rpcHeaderPacket.enableRerouting();
        }
        rpcHeaderPacket.setTimeout(payload.getTimeout() * 1000L);
        rpcHeaderPacket.setTenantId(payload.getTenantId());
        rpcHeaderPacket.setTraceId0(payload.getUniqueId());
        rpcHeaderPacket.setTraceId1(payload.getSequence());
        if (payload instanceof ObTableStreamRequest) {
            rpcHeaderPacket.setSessionId(((ObTableStreamRequest)payload).getSessionId());
            rpcHeaderPacket.setFlag(((ObTableStreamRequest)payload).getFlag());
        }
        rpcHeaderPacket.setPriority(ThreadLocalMap.getProcessPriority());
        rpcHeaderPacket.setChecksum(ObPureCrc32C.calculate(payloadContent));
        ObRpcPacket rpcPacket = new ObRpcPacket();
        rpcPacket.setRpcPacketHeader(rpcHeaderPacket);
        rpcPacket.setPayloadContent(payloadContent);
        return rpcPacket.encode();
    }

    public ObTablePacket createTimeoutResponse(InetSocketAddress address) {
        return ObTablePacket.createTransportErrorPacket(-20002, "connection {" + address.toString() + "} timeout", null);
    }

    public ObTablePacket createSendFailedResponse(InetSocketAddress address, Throwable throwable) {
        return ObTablePacket.createTransportErrorPacket(-20003, "connection {" + address.toString() + "} send failed", throwable);
    }

    public ObTablePacket createExceptionResponse(int id, Throwable t, String errMsg) {
        return null;
    }

    public ObTablePacket createExceptionResponse(int id, ResponseStatus status) {
        return null;
    }

    public ObTablePacket createExceptionResponse(int id, String errMsg) {
        return null;
    }

    public ObTablePacket createResponse(Object responseObject, RemotingCommand requestCmd) {
        return null;
    }

    public ObTablePacket createExceptionResponse(int id, ResponseStatus status, Throwable t) {
        return null;
    }

    public ObTablePacket createConnectionClosedResponse(InetSocketAddress address, String message) {
        return null;
    }
}

