/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model;

import com.alipay.oceanbase.rpc.util.StringUtil;

public class TableEntryKey {
    private String clusterName = "";
    private String tenantName = "";
    private String databaseName = "";
    private String tableName = "";

    public TableEntryKey() {
    }

    public TableEntryKey(String clusterName, String tenantName, String databaseName, String tableName) {
        this.clusterName = clusterName;
        this.tenantName = tenantName;
        this.databaseName = databaseName;
        this.tableName = tableName;
    }

    public static TableEntryKey getDummyEntryKey(String clusterName, String tenantName) {
        TableEntryKey dummyKey = new TableEntryKey(clusterName, tenantName, "oceanbase", "__all_dummy");
        return dummyKey;
    }

    public static TableEntryKey getSysDummyEntryKey(String clusterName) {
        return TableEntryKey.getDummyEntryKey(clusterName, "sys");
    }

    public boolean isSysAllDummy() {
        return this.tenantName.equals("sys") && this.isAllDummy();
    }

    public boolean isAllDummy() {
        return this.databaseName.equals("oceanbase") && this.tableName.equals("__all_dummy");
    }

    public boolean isValid() {
        return StringUtil.isNotEmpty(this.clusterName) && StringUtil.isNotEmpty(this.tenantName) && StringUtil.isNotEmpty(this.databaseName) && StringUtil.isNotEmpty(this.tableName);
    }

    public String toString() {
        return "TableEntryKey [clusterName=" + this.clusterName + ", tenantName=" + this.tenantName + ", databaseName=" + this.databaseName + ", tableName=" + this.tableName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
        result = 31 * result + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        result = 31 * result + (this.tenantName == null ? 0 : this.tenantName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableEntryKey other = (TableEntryKey)obj;
        if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
            return false;
        }
        if (this.databaseName == null ? other.databaseName != null : !this.databaseName.equals(other.databaseName)) {
            return false;
        }
        if (this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName)) {
            return false;
        }
        return !(this.tenantName == null ? other.tenantName != null : !this.tenantName.equals(other.tenantName));
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

