/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionLevel;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ObPartitionInfo {
    private ObPartitionLevel level = ObPartitionLevel.UNKNOWN;
    private ObPartDesc firstPartDesc = null;
    private ObPartDesc subPartDesc = null;
    private List<ObColumn> partColumns = new ArrayList<ObColumn>(1);
    private Map<Long, Long> partTabletIdMap = null;
    private Map<String, Long> partNameIdMap = null;
    private Map<String, Integer> rowKeyElement = null;

    public ObPartitionLevel getLevel() {
        return this.level;
    }

    public void setLevel(ObPartitionLevel level) {
        this.level = level;
    }

    public ObPartDesc getFirstPartDesc() {
        return this.firstPartDesc;
    }

    public void setFirstPartDesc(ObPartDesc firstPartDesc) {
        this.firstPartDesc = firstPartDesc;
    }

    public ObPartDesc getSubPartDesc() {
        return this.subPartDesc;
    }

    public void setSubPartDesc(ObPartDesc subPartDesc) {
        this.subPartDesc = subPartDesc;
    }

    public List<ObColumn> getPartColumns() {
        return this.partColumns;
    }

    public void addColumn(ObColumn column) {
        this.partColumns.add(column);
    }

    public Map<String, Integer> getRowKeyElement() {
        return this.rowKeyElement;
    }

    public void setRowKeyElement(Map<String, Integer> rowKeyElement) {
        this.rowKeyElement = rowKeyElement;
        if (this.firstPartDesc != null) {
            this.firstPartDesc.setRowKeyElement(rowKeyElement);
        }
        if (this.subPartDesc != null) {
            this.subPartDesc.setRowKeyElement(rowKeyElement);
        }
    }

    public void prepare() throws IllegalArgumentException {
        Preconditions.checkArgument((this.level != ObPartitionLevel.UNKNOWN ? 1 : 0) != 0, (Object)"unknown partition level");
        if (this.level.getIndex() >= ObPartitionLevel.LEVEL_ONE.getIndex()) {
            Preconditions.checkArgument((this.firstPartDesc != null ? 1 : 0) != 0, (Object)"firstPartDesc can not be null when level above level one");
            this.firstPartDesc.prepare();
        }
        if (this.level.getIndex() == ObPartitionLevel.LEVEL_TWO.getIndex()) {
            Preconditions.checkArgument((this.subPartDesc != null ? 1 : 0) != 0, (Object)"subPartDesc can not be null when level is level two");
            this.subPartDesc.prepare();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ObPartitionInfo{");
        sb.append("level=").append((Object)this.level);
        sb.append(", firstPartDesc=").append(this.firstPartDesc);
        sb.append(", subPartDesc=").append(this.subPartDesc);
        sb.append(", partColumns=").append(this.partColumns);
        sb.append('}');
        return sb.toString();
    }

    public Map<String, Long> getPartNameIdMap() {
        return this.partNameIdMap;
    }

    public void setPartNameIdMap(Map<String, Long> partNameIdMap) {
        this.partNameIdMap = partNameIdMap;
    }

    public Map<Long, Long> getPartTabletIdMap() {
        return this.partTabletIdMap;
    }

    public void setPartTabletIdMap(Map<Long, Long> partTabletIdMap) {
        this.partTabletIdMap = partTabletIdMap;
    }
}

