/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.mutation.result;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.mutation.result.OperationResult;
import java.util.ArrayList;
import java.util.List;

public class BatchOperationResult {
    private List<Object> results;

    public BatchOperationResult(List<Object> results) {
        this.results = results;
    }

    public OperationResult get(int pos) {
        if (pos >= this.results.size()) {
            throw new IllegalArgumentException("Invalid pos: " + pos + ", while size of results is: " + this.results.size());
        }
        return (MutationResult)this.results.get(pos);
    }

    public int size() {
        return this.results.size();
    }

    public long getWrongCount() {
        long wrongCount = 0L;
        for (Object item : this.results) {
            if (!(item instanceof ObTableException)) continue;
            ++wrongCount;
        }
        return wrongCount;
    }

    public long getCorrectCount() {
        long correctCount = 0L;
        for (Object item : this.results) {
            if (item instanceof ObTableException) continue;
            ++correctCount;
        }
        return correctCount;
    }

    public int[] getWrongIdx() {
        ArrayList<Integer> wrongIdx = new ArrayList<Integer>();
        Integer i = 0;
        for (Object item : this.results) {
            if (item instanceof ObTableException) {
                wrongIdx.add(i);
            }
            i = i + 1;
        }
        return wrongIdx.stream().mapToInt(Integer::intValue).toArray();
    }

    public int[] getCorrectIdx() {
        ArrayList<Integer> correctIdx = new ArrayList<Integer>();
        Integer i = 0;
        for (Object item : this.results) {
            if (!(item instanceof ObTableException)) {
                correctIdx.add(i);
            }
            i = i + 1;
        }
        return correctIdx.stream().mapToInt(Integer::intValue).toArray();
    }
}

