/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjMeta;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObITableEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableOperation
extends AbstractPayload {
    private ObTableOperationType operationType;
    private ObITableEntity entity;

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        System.arraycopy(Serialization.encodeI8(this.operationType.getByteValue()), 0, bytes, idx += headerLen, 1);
        long len = this.entity.getPayloadSize();
        System.arraycopy(this.entity.encode(), 0, bytes, ++idx, (int)len);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.operationType = ObTableOperationType.valueOf(Serialization.decodeI8(buf.readByte()));
        this.entity = new ObTableEntity();
        this.entity.decode(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return 1L + this.entity.getPayloadSize();
    }

    public ObTableOperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(ObTableOperationType operationType) {
        this.operationType = operationType;
    }

    public ObITableEntity getEntity() {
        return this.entity;
    }

    public void setEntity(ObITableEntity entity) {
        this.entity = entity;
    }

    public static ObTableOperation getInstance(ObTableOperationType type, Object[] rowKeys, String[] columns, Object[] properties) {
        int i;
        ObTableOperation obTableOperation = new ObTableOperation();
        obTableOperation.setOperationType(type);
        ObTableEntity entity = new ObTableEntity();
        obTableOperation.setEntity(entity);
        for (i = 0; i < rowKeys.length; ++i) {
            Object rowkey = rowKeys[i];
            ObObjMeta rowkeyMeta = ObObjType.defaultObjMeta(rowkey);
            ObObj obj = new ObObj();
            obj.setMeta(rowkeyMeta);
            obj.setValue(rowkey);
            entity.addRowKeyValue(obj);
        }
        if (columns != null) {
            for (i = 0; i < columns.length; ++i) {
                String name = columns[i];
                Object value = null;
                if (properties != null) {
                    value = properties[i];
                }
                ObObjMeta meta = ObObjType.defaultObjMeta(value);
                ObObj c = new ObObj();
                c.setMeta(meta);
                c.setValue(value);
                entity.setProperty(name, c);
            }
        }
        return obTableOperation;
    }

    public boolean isReadonly() {
        return this.operationType.isReadonly();
    }
}

