/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObITableEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableResult;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableOperationResult
extends AbstractPayload {
    private ObTableResult header = new ObTableResult();
    private ObTableOperationType operationType = ObTableOperationType.GET;
    private ObITableEntity entity = new ObTableEntity();
    private long affectedRows = 0L;
    private String executeHost;
    private int executePort;

    @Override
    public int getPcode() {
        return 4354;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int len = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadSize());
        byte[] header = Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadSize());
        System.arraycopy(header, 0, bytes, idx, len);
        idx += len;
        len = (int)this.header.getPayloadSize();
        System.arraycopy(this.header.encode(), 0, bytes, idx, len);
        System.arraycopy(Serialization.encodeI8(this.operationType.getByteValue()), 0, bytes, idx += len, 1);
        len = (int)this.entity.getPayloadSize();
        System.arraycopy(this.entity.encode(), 0, bytes, ++idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.affectedRows);
        System.arraycopy(Serialization.encodeVi64(this.affectedRows), 0, bytes, idx, len);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.header.decode(buf);
        this.operationType = ObTableOperationType.valueOf(Serialization.decodeI8(buf.readByte()));
        this.entity.decode(buf);
        this.affectedRows = Serialization.decodeVi64(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return 1L + this.header.getPayloadSize() + this.entity.getPayloadSize() + (long)Serialization.getNeedBytes(this.affectedRows);
    }

    public ObTableResult getHeader() {
        return this.header;
    }

    public void setHeader(ObTableResult header) {
        this.header = header;
    }

    public ObTableOperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(ObTableOperationType operationType) {
        this.operationType = operationType;
    }

    public ObITableEntity getEntity() {
        return this.entity;
    }

    public void setEntity(ObITableEntity entity) {
        this.entity = entity;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public void setAffectedRows(long affectedRows) {
        this.affectedRows = affectedRows;
    }

    public String getExecuteHost() {
        return this.executeHost;
    }

    public void setExecuteHost(String executeHost) {
        this.executeHost = executeHost;
    }

    public int getExecutePort() {
        return this.executePort;
    }

    public void setExecutePort(int executePort) {
        this.executePort = executePort;
    }
}

