/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.parser;

import com.alipay.oceanbase.rpc.exception.GenerateColumnParseException;
import com.alipay.oceanbase.rpc.protocol.payload.impl.parser.ObGeneratedColumnCharType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.parser.ObGeneratedColumnSimpleToken;
import java.math.BigInteger;

public class ObGeneratedColumnLexer {
    private final String text;
    protected char ch;
    private int pos;
    private int mark;
    protected ObGeneratedColumnSimpleToken token;
    protected char[] buf;
    private int bufPos;
    protected String stringVal;
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final int[] digits = new int[58];

    public ObGeneratedColumnLexer(String text) {
        this.text = text;
        this.pos = -1;
        this.scanChar();
        this.nextToken();
    }

    protected void nextToken() {
        this.bufPos = 0;
        while (ObGeneratedColumnCharType.isWhitespace(this.ch)) {
            this.scanChar();
        }
        if (ObGeneratedColumnCharType.isFirstIdentifierChar(this.ch)) {
            this.scanIdentifier();
            return;
        }
        switch (this.ch) {
            case '0': {
                if (this.charAt(this.pos + 1) == 'x') {
                    this.scanChar();
                    this.scanChar();
                    this.scanHexaDecimal();
                } else {
                    this.scanNumber();
                }
                return;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.scanNumber();
                return;
            }
            case ',': 
            case '\uff0c': {
                this.scanChar();
                this.token = ObGeneratedColumnSimpleToken.COMMA;
                return;
            }
            case '(': {
                this.scanChar();
                this.token = ObGeneratedColumnSimpleToken.LPAREN;
                return;
            }
            case ')': {
                this.scanChar();
                this.token = ObGeneratedColumnSimpleToken.RPAREN;
                return;
            }
            case '-': {
                this.scanOperator();
                return;
            }
        }
        if (this.isEOF()) {
            this.token = ObGeneratedColumnSimpleToken.EOF;
        } else {
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.scanChar();
        }
    }

    protected void lexError(String key, Object ... args) {
        this.token = ObGeneratedColumnSimpleToken.ERROR;
    }

    protected final void scanChar() {
        this.ch = this.charAt(++this.pos);
    }

    public final char charAt(int index) {
        if (index >= this.text.length()) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    protected void skipWhitespace() {
        while (true) {
            if (this.isEOF()) {
                return;
            }
            if (!ObGeneratedColumnCharType.isWhitespace(this.ch)) break;
            this.scanChar();
        }
    }

    public void scanIdentifier() {
        char ch;
        this.skipWhitespace();
        char first = this.ch;
        boolean firstFlag = ObGeneratedColumnCharType.isFirstIdentifierChar(first);
        if (!firstFlag) {
            throw new GenerateColumnParseException("illegal identifier");
        }
        this.mark = this.pos;
        this.bufPos = 1;
        while (ObGeneratedColumnCharType.isIdentifierChar(ch = this.charAt(++this.pos))) {
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.addSymbol();
        this.token = ObGeneratedColumnSimpleToken.IDENTIFIER;
    }

    public void scanHexaDecimal() {
        this.mark = this.pos++;
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
        }
        while (ObGeneratedColumnCharType.isHex(this.ch)) {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        this.token = ObGeneratedColumnSimpleToken.LITERAL_HEX;
    }

    public void scanNumber() {
        this.mark = this.pos++;
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            if (this.charAt(this.pos + 1) == '.') {
                this.token = ObGeneratedColumnSimpleToken.LITERAL_INT;
                return;
            }
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            if (this.ch == '+' || this.ch == '-') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            isDouble = true;
        }
        this.token = isDouble ? ObGeneratedColumnSimpleToken.LITERAL_FLOAT : ObGeneratedColumnSimpleToken.LITERAL_INT;
    }

    private void scanOperator() {
        switch (this.ch) {
            case '+': {
                this.scanChar();
                this.token = ObGeneratedColumnSimpleToken.PLUS;
                break;
            }
            case '-': {
                this.scanChar();
                this.token = ObGeneratedColumnSimpleToken.SUB;
                break;
            }
            default: {
                this.token = ObGeneratedColumnSimpleToken.ERROR;
            }
        }
    }

    public boolean isEOF() {
        return this.pos >= this.text.length();
    }

    public final String addSymbol() {
        return this.subString(this.mark, this.bufPos);
    }

    public final String subString(int offset, int count) {
        return this.text.substring(offset, offset + count);
    }

    public Number integerValue() {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.mark;
        int max = this.mark + this.bufPos;
        if (this.charAt(this.mark) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max) {
            digit = digits[this.charAt(i++)];
            if (result < multmin) {
                return new BigInteger(this.addSymbol());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.addSymbol());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.mark + 1) {
                if (result >= Integer.MIN_VALUE) {
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.addSymbol());
        }
        if ((result = -result) <= Integer.MAX_VALUE) {
            return (int)result;
        }
        return result;
    }

    public ObGeneratedColumnSimpleToken token() {
        return this.token;
    }

    public String stringVal() {
        return this.stringVal;
    }

    public int pos() {
        return this.pos;
    }

    static {
        for (int i = 48; i <= 57; ++i) {
            ObGeneratedColumnLexer.digits[i] = i - 48;
        }
    }
}

