/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class ObDirectLoadObjRow
implements ObSimplePayload {
    private long SeqNo = 0L;
    private ObObj[] cells = new ObObj[0];

    public ObDirectLoadObjRow() {
    }

    public ObDirectLoadObjRow(ObObj[] cells) {
        this.setCells(cells);
        this.setSeqNo(0L);
    }

    public ObDirectLoadObjRow(List<ObObj> cells) {
        this.setCells(cells);
        this.setSeqNo(0L);
    }

    public ObObj[] getCells() {
        return this.cells;
    }

    public void setCells(ObObj[] cells) {
        if (cells == null) {
            throw new NullPointerException();
        }
        this.cells = cells;
    }

    public void setCells(List<ObObj> cells) {
        if (cells == null) {
            throw new NullPointerException();
        }
        this.cells = cells.toArray(new ObObj[0]);
    }

    public void setSeqNo(long SeqNo) {
        this.SeqNo = SeqNo;
    }

    public long getSeqNo() {
        return this.SeqNo;
    }

    @Override
    public byte[] encode() {
        int needBytes = this.getEncodedSize();
        ObByteBuf buf = new ObByteBuf(needBytes);
        this.encode(buf);
        return buf.bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        Serialization.encodeVi64(buf, this.SeqNo);
        Serialization.encodeVi32(buf, this.cells.length);
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].encode(buf);
        }
    }

    @Override
    public ObDirectLoadObjRow decode(ByteBuf buf) {
        this.SeqNo = Serialization.decodeVi64(buf);
        int count = Serialization.decodeVi32(buf);
        this.cells = new ObObj[count];
        for (int i = 0; i < count; ++i) {
            ObObj obj = new ObObj();
            obj.decode(buf);
            this.cells[i] = obj;
        }
        return this;
    }

    @Override
    public int getEncodedSize() {
        int size = 0;
        size += Serialization.getNeedBytes(this.SeqNo);
        size += Serialization.getNeedBytes(this.cells.length);
        for (int i = 0; i < this.cells.length; ++i) {
            size += this.cells[i].getEncodedSize();
        }
        return size;
    }
}

