/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Serialization {
    private static final long OB_MAX_V1B = 127L;
    private static final long OB_MAX_V2B = 16383L;
    private static final long OB_MAX_V3B = 0x1FFFFFL;
    private static final long OB_MAX_V4B = 0xFFFFFFFL;
    private static final long OB_MAX_V5B = 0x7FFFFFFFFL;
    private static final long OB_MAX_V6B = 0x3FFFFFFFFFFL;
    private static final long OB_MAX_V7B = 0x1FFFFFFFFFFFFL;
    private static final long OB_MAX_V8B = 0xFFFFFFFFFFFFFFL;
    private static final long OB_MAX_V9B = Long.MAX_VALUE;
    private static final long[] OB_MAX = new long[]{127L, 16383L, 0x1FFFFFL, 0xFFFFFFFL, 0x7FFFFFFFFL, 0x3FFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, Long.MAX_VALUE};

    public static byte[] encodeObString(String val) {
        byte[] strbytes = Serialization.strToBytes(val);
        byte[] length = Serialization.encodeI64(strbytes.length);
        byte[] bytes = new byte[length.length + strbytes.length + 1];
        System.arraycopy(length, 0, bytes, 0, length.length);
        System.arraycopy(strbytes, 0, bytes, length.length, strbytes.length);
        bytes[bytes.length - 1] = 0;
        return bytes;
    }

    public static void encodeObString(ObByteBuf buf, String val) {
        byte[] strBytes = Serialization.strToBytes(val);
        Serialization.encodeI64(buf, strBytes.length);
        buf.writeBytes(strBytes);
        buf.writeByte((byte)0);
    }

    public static byte[] strToBytes(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static String bytesToStr(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static long getObStringSerializeSize(long val) {
        return Serialization.encodeLengthVi64(val) + val + 1L;
    }

    public static long getObStringSerializeSize(String val) {
        return Serialization.getObStringSerializeSize(val.length());
    }

    public static long encodeLengthVi64(long len) {
        int needBytes = len < 127L ? 1 : (len < 16383L ? 2 : (len < 0x1FFFFFL ? 3 : (len < 0xFFFFFFFL ? 4 : (len < 0x7FFFFFFFFL ? 5 : (len < 0x3FFFFFFFFFFL ? 6 : (len < 0x1FFFFFFFFFFFFL ? 7 : (len < 0xFFFFFFFFFFFFFFL ? 8 : (len < Long.MAX_VALUE ? 9 : 10))))))));
        return needBytes;
    }

    public static byte[] encodeI8(byte val) {
        byte[] bytes = new byte[]{(byte)(val & 0xFF)};
        return bytes;
    }

    public static void encodeI8(ObByteBuf buf, byte val) {
        if (buf == null) {
            throw new NullPointerException();
        }
        buf.writeByte((byte)(val & 0xFF));
    }

    public static byte[] encodeI8(short val) {
        byte[] bytes = new byte[]{(byte)(val & 0xFF)};
        return bytes;
    }

    public static void encodeI8(ObByteBuf buf, short val) {
        if (buf == null) {
            throw new NullPointerException();
        }
        buf.writeByte((byte)(val & 0xFF));
    }

    public static byte[] encodeI16(short val) {
        byte[] bytes = new byte[4];
        bytes[0] = (byte)(val >> 8 & 0xFF);
        bytes[1] = (byte)(val & 0xFF);
        return bytes;
    }

    public static void encodeI16(ObByteBuf buf, short val) {
        if (buf == null) {
            throw new NullPointerException();
        }
        buf.writeByte((byte)(val >> 8 & 0xFF));
        buf.writeByte((byte)(val & 0xFF));
    }

    public static byte[] encodeI32(int val) {
        byte[] bytes = new byte[]{(byte)(val >> 24 & 0xFF), (byte)(val >> 16 & 0xFF), (byte)(val >> 8 & 0xFF), (byte)(val & 0xFF)};
        return bytes;
    }

    public static void encodeI32(ObByteBuf buf, int val) {
        if (buf == null) {
            throw new NullPointerException();
        }
        buf.writeByte((byte)(val >> 24 & 0xFF));
        buf.writeByte((byte)(val >> 16 & 0xFF));
        buf.writeByte((byte)(val >> 8 & 0xFF));
        buf.writeByte((byte)(val & 0xFF));
    }

    public static byte[] encodeI64(long val) {
        byte[] bytes = new byte[]{(byte)(val >> 56 & 0xFFL), (byte)(val >> 48 & 0xFFL), (byte)(val >> 40 & 0xFFL), (byte)(val >> 32 & 0xFFL), (byte)(val >> 24 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val & 0xFFL)};
        return bytes;
    }

    public static void encodeI64(ObByteBuf buf, long val) {
        if (buf == null) {
            throw new NullPointerException();
        }
        buf.writeByte((byte)(val >> 56 & 0xFFL));
        buf.writeByte((byte)(val >> 48 & 0xFFL));
        buf.writeByte((byte)(val >> 40 & 0xFFL));
        buf.writeByte((byte)(val >> 32 & 0xFFL));
        buf.writeByte((byte)(val >> 24 & 0xFFL));
        buf.writeByte((byte)(val >> 16 & 0xFFL));
        buf.writeByte((byte)(val >> 8 & 0xFFL));
        buf.writeByte((byte)(val & 0xFFL));
    }

    public static byte decodeI8(ByteBuf val) {
        return (byte)(val.readByte() & 0xFF);
    }

    public static short decodeUI8(ByteBuf val) {
        return (short)(val.readUnsignedByte() & 0xFFFF);
    }

    public static byte decodeI8(byte val) {
        return (byte)(val & 0xFF);
    }

    public static byte decodeI8(byte[] val) {
        return (byte)(val[0] & 0xFF);
    }

    public static short decodeI16(ByteBuf val) {
        short ret = (short)((val.readByte() & 0xFF) << 8);
        ret = (short)(ret | val.readByte() & 0xFF);
        return ret;
    }

    public static short decodeI16(byte[] val) {
        short ret = (short)((val[0] & 0xFF) << 8);
        ret = (short)(ret | val[1] & 0xFF);
        return ret;
    }

    public static int decodeI32(byte[] val) {
        int ret = (val[0] & 0xFF) << 24;
        ret |= (val[1] & 0xFF) << 16;
        ret |= (val[2] & 0xFF) << 8;
        return ret |= val[3] & 0xFF;
    }

    public static int decodeI32(ByteBuf val) {
        int ret = (val.readByte() & 0xFF) << 24;
        ret |= (val.readByte() & 0xFF) << 16;
        ret |= (val.readByte() & 0xFF) << 8;
        return ret |= val.readByte() & 0xFF;
    }

    public static long decodeI64(byte[] val) {
        long ret = (long)(val[0] & 0xFF) << 56;
        ret |= (long)(val[1] & 0xFF) << 48;
        ret |= (long)(val[2] & 0xFF) << 40;
        ret |= (long)(val[3] & 0xFF) << 32;
        ret |= (long)(val[4] & 0xFF) << 24;
        ret |= (long)(val[5] & 0xFF) << 16;
        ret |= (long)(val[6] & 0xFF) << 8;
        return ret |= (long)(val[7] & 0xFF);
    }

    public static long decodeI64(ByteBuf val) {
        long ret = (long)(val.readByte() & 0xFF) << 56;
        ret |= (long)(val.readByte() & 0xFF) << 48;
        ret |= (long)(val.readByte() & 0xFF) << 40;
        ret |= (long)(val.readByte() & 0xFF) << 32;
        ret |= (long)(val.readByte() & 0xFF) << 24;
        ret |= (long)(val.readByte() & 0xFF) << 16;
        ret |= (long)(val.readByte() & 0xFF) << 8;
        return ret |= (long)(val.readByte() & 0xFF);
    }

    public static double decodeDouble(ByteBuf buffer) {
        return Double.longBitsToDouble(Serialization.decodeVi64(buffer));
    }

    public static byte[] encodeDouble(double d) {
        return Serialization.encodeVi64(Double.doubleToRawLongBits(d));
    }

    public static void encodeDouble(ObByteBuf buf, double d) {
        Serialization.encodeVi64(buf, Double.doubleToRawLongBits(d));
    }

    public static float decodeFloat(ByteBuf value) {
        return Float.intBitsToFloat(Serialization.decodeVi32(value));
    }

    public static byte[] encodeFloat(float f) {
        return Serialization.encodeVi32(Float.floatToRawIntBits(f));
    }

    public static void encodeFloat(ObByteBuf buf, float f) {
        Serialization.encodeVi32(buf, Float.floatToRawIntBits(f));
    }

    public static int getNeedBytes(long l) {
        if (l < 0L) {
            return 10;
        }
        int needBytes = 0;
        for (long max : OB_MAX) {
            ++needBytes;
            if (l <= max) break;
        }
        return needBytes;
    }

    public static int getNeedBytes(int l) {
        if (l < 0) {
            return 5;
        }
        int needBytes = 0;
        for (long max : OB_MAX) {
            ++needBytes;
            if ((long)l <= max) break;
        }
        return needBytes;
    }

    public static int getNeedBytes(ObBytesString str) {
        if (str == null) {
            str = new ObBytesString(new byte[0]);
        }
        return Serialization.getNeedBytes(str.length()) + str.length() + 1;
    }

    public static int getNeedBytes(double val) {
        return Serialization.getNeedBytes(Double.doubleToRawLongBits(val));
    }

    public static int getNeedBytes(float val) {
        return Serialization.getNeedBytes(Float.floatToRawIntBits(val));
    }

    public static int getNeedBytes(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        return Serialization.getNeedBytes(bytes.length) + bytes.length;
    }

    public static int getNeedBytes(String str) {
        if (str == null) {
            str = "";
        }
        int len = Serialization.strToBytes(str).length;
        return Serialization.getNeedBytes(len) + len + 1;
    }

    public static byte[] encodeVi32(int i) {
        byte[] ret = new byte[Serialization.getNeedBytes(i)];
        int index = 0;
        while (i < 0 || (long)i > 127L) {
            ret[index++] = (byte)(i | 0x80);
            i >>>= 7;
        }
        ret[index] = (byte)(i & 0x7F);
        return ret;
    }

    public static void encodeVi32(ObByteBuf buf, int i) {
        if (buf == null) {
            throw new NullPointerException();
        }
        while (i < 0 || (long)i > 127L) {
            buf.writeByte((byte)(i | 0x80));
            i >>>= 7;
        }
        buf.writeByte((byte)(i & 0x7F));
    }

    public static int decodeVi32(byte[] value) {
        int ret = 0;
        int shift = 0;
        for (byte b : value) {
            ret |= (b & 0x7F) << shift;
            shift += 7;
            if ((b & 0x80) == 0) break;
        }
        return ret;
    }

    public static int decodeVi32(ByteBuf buffer) {
        byte b;
        int ret = 0;
        int shift = 0;
        do {
            b = buffer.readByte();
            ret |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return ret;
    }

    public static long decodeVi64(ByteBuf buffer) {
        byte b;
        long ret = 0L;
        int shift = 0;
        do {
            b = buffer.readByte();
            ret |= ((long)b & 0x7FL) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return ret;
    }

    public static byte[] encodeVi64(long l) {
        byte[] ret = new byte[Serialization.getNeedBytes(l)];
        int index = 0;
        while (l < 0L || l > 127L) {
            ret[index++] = (byte)(l | 0x80L);
            l >>>= 7;
        }
        ret[index] = (byte)(l & 0x7FL);
        return ret;
    }

    public static void encodeVi64(ObByteBuf buf, long l) {
        if (buf == null) {
            throw new NullPointerException();
        }
        while (l < 0L || l > 127L) {
            buf.writeByte((byte)(l | 0x80L));
            l >>>= 7;
        }
        buf.writeByte((byte)(l & 0x7FL));
    }

    public static long decodeVi64(byte[] value) {
        long ret = 0L;
        int shift = 0;
        for (byte b : value) {
            ret |= ((long)b & 0x7FL) << shift;
            shift += 7;
            if ((b & 0x80) == 0) break;
        }
        return ret;
    }

    public static byte[] encodeVString(String str) {
        return Serialization.encodeVString(str, StandardCharsets.UTF_8);
    }

    public static void encodeVString(ObByteBuf buf, String str) {
        Serialization.encodeVString(buf, str, StandardCharsets.UTF_8);
    }

    public static byte[] encodeBytesString(ObBytesString str) {
        if (str == null) {
            str = new ObBytesString(new byte[0]);
        }
        byte[] data = str.bytes;
        int dataLen = data.length;
        int strLen = Serialization.getNeedBytes(dataLen);
        byte[] ret = new byte[strLen + dataLen + 1];
        int index = 0;
        for (byte b : Serialization.encodeVi32(dataLen)) {
            ret[index++] = b;
        }
        for (byte b : data) {
            ret[index++] = b;
        }
        ret[index] = 0;
        return ret;
    }

    public static void encodeBytesString(ObByteBuf buf, ObBytesString str) {
        if (buf == null) {
            throw new NullPointerException();
        }
        int dataLen = str == null ? 0 : str.length();
        Serialization.encodeVi32(buf, dataLen);
        if (str != null) {
            buf.writeBytes(str.bytes);
        }
        buf.writeByte((byte)0);
    }

    public static byte[] encodeBytes(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        byte[] data = bytes;
        int dataLen = data.length;
        int strLen = Serialization.getNeedBytes(dataLen);
        byte[] ret = new byte[strLen + dataLen];
        int index = 0;
        for (byte b : Serialization.encodeVi32(dataLen)) {
            ret[index++] = b;
        }
        for (byte b : data) {
            ret[index++] = b;
        }
        return ret;
    }

    public static void encodeBytes(ObByteBuf buf, byte[] bytes) {
        if (buf == null) {
            throw new NullPointerException();
        }
        int bytesLen = bytes != null ? bytes.length : 0;
        Serialization.encodeVi32(buf, bytesLen);
        if (bytes != null) {
            buf.writeBytes(bytes);
        }
    }

    public static byte[] encodeVString(String str, String charset) {
        if (str == null) {
            str = "";
        }
        try {
            byte[] data = str.getBytes(charset);
            int dataLen = data.length;
            int strLen = Serialization.getNeedBytes(dataLen);
            byte[] ret = new byte[strLen + dataLen + 1];
            int index = 0;
            for (byte b : Serialization.encodeVi32(dataLen)) {
                ret[index++] = b;
            }
            for (byte b : data) {
                ret[index++] = b;
            }
            ret[index] = 0;
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encodeVString(String str, Charset charset) {
        if (str == null) {
            str = "";
        }
        byte[] data = str.getBytes(charset);
        int dataLen = data.length;
        int strLen = Serialization.getNeedBytes(dataLen);
        byte[] ret = new byte[strLen + dataLen + 1];
        int index = 0;
        for (byte b : Serialization.encodeVi32(dataLen)) {
            ret[index++] = b;
        }
        for (byte b : data) {
            ret[index++] = b;
        }
        ret[index] = 0;
        return ret;
    }

    public static void encodeVString(ObByteBuf buf, String str, Charset charset) {
        if (buf == null || str == null) {
            throw new NullPointerException();
        }
        byte[] strBytes = str.getBytes(charset);
        Serialization.encodeVi32(buf, strBytes.length);
        buf.writeBytes(strBytes);
        buf.writeByte((byte)0);
    }

    public static ObBytesString decodeBytesString(ByteBuf buf) {
        int dataLen = Serialization.decodeVi32(buf);
        byte[] content = new byte[dataLen];
        buf.readBytes(content);
        buf.readByte();
        return new ObBytesString(content);
    }

    public static byte[] decodeBytes(ByteBuf buf) {
        int dataLen = Serialization.decodeVi32(buf);
        byte[] content = new byte[dataLen];
        buf.readBytes(content);
        return content;
    }

    public static String decodeVString(ByteBuf buf) {
        return Serialization.decodeVString(buf, StandardCharsets.UTF_8);
    }

    public static String decodeVString(ByteBuf buffer, String charset) {
        int dataLen = Serialization.decodeVi32(buffer);
        byte[] content = new byte[dataLen];
        buffer.readBytes(content);
        buffer.readByte();
        return Serialization.decodeVString(content, charset);
    }

    public static String decodeVString(ByteBuf buffer, Charset charset) {
        int dataLen = Serialization.decodeVi32(buffer);
        byte[] content = new byte[dataLen];
        buffer.readBytes(content);
        buffer.readByte();
        return Serialization.decodeVString(content, charset);
    }

    public static String decodeVString(byte[] content) {
        return Serialization.decodeVString(content, StandardCharsets.UTF_8);
    }

    public static String decodeVString(byte[] content, String charset) {
        try {
            return new String(content, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("can not decode to " + charset, e);
        }
    }

    public static String decodeVString(byte[] content, Charset charset) {
        return new String(content, charset);
    }

    public static long getObUniVersionHeaderLength(long version, long payloadLen) {
        return Serialization.getNeedBytes(version) + Serialization.getNeedBytes(payloadLen);
    }

    public static byte[] encodeObUniVersionHeader(long version, long payloadLen) {
        byte[] bytes = new byte[(int)Serialization.getObUniVersionHeaderLength(version, payloadLen)];
        int idx = 0;
        int len = Serialization.getNeedBytes(version);
        System.arraycopy(Serialization.encodeVi64(version), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(payloadLen);
        System.arraycopy(Serialization.encodeVi64(payloadLen), 0, bytes, idx, len);
        return bytes;
    }

    public static void encodeObUniVersionHeader(ObByteBuf buf, long version, long payloadLen) {
        Serialization.encodeVi64(buf, version);
        Serialization.encodeVi64(buf, payloadLen);
    }
}

