/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

public class StringUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static final boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static final boolean isBlank(String str) {
        int strLen = 0;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String alignRight(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        return StringUtil.alignRight(str, size, String.valueOf(padChar));
    }

    public static String alignRight(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (padStr == null || padStr.length() == 0) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String replaceOnce(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, 1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || with == null || repl.length() == 0 || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String[] parseNamePattern(String pattern) {
        String toPadding;
        String fromPadding;
        int headerIdx = pattern.indexOf("{");
        int footerIdx = pattern.indexOf("}");
        String header = pattern.substring(0, headerIdx);
        String footer = pattern.substring(footerIdx + 1);
        String[] temp = (pattern = pattern.substring(headerIdx + 1, footerIdx)).split("-");
        if (temp.length != 2) {
            throw new IllegalArgumentException();
        }
        temp[0] = temp[0].trim();
        temp[1] = temp[1].trim();
        int firstNumFrom = StringUtil.firstNum(temp[0]);
        int firstNot0From = StringUtil.firstNot0(temp[0], firstNumFrom);
        int firstNumTo = StringUtil.firstNum(temp[1]);
        int firstNot0To = StringUtil.firstNot0(temp[1], firstNumTo);
        if (firstNumFrom == -1 || firstNumTo == -1) {
            throw new IllegalArgumentException();
        }
        if (firstNumFrom != firstNumTo) {
            throw new IllegalArgumentException("padding width different");
        }
        if (!(temp[0].length() == temp[1].length() || firstNot0From == -1 && firstNumFrom == temp[0].length() - 1 && firstNot0To == firstNumTo || firstNot0From == firstNumFrom && firstNot0To == firstNumTo)) {
            throw new IllegalArgumentException("dbindex width different");
        }
        if (firstNumFrom != 0 && !(fromPadding = temp[0].substring(0, firstNumFrom)).equals(toPadding = temp[1].substring(0, firstNumTo))) {
            throw new IllegalArgumentException("padding different");
        }
        int suffixFrom = firstNot0From == -1 ? 0 : Integer.parseInt(temp[0].substring(firstNot0From));
        int suffixTo = Integer.parseInt(temp[1].substring(firstNot0To));
        if (suffixTo <= suffixFrom) {
            throw new IllegalArgumentException("length is error");
        }
        int suffixWidth = temp[0].length() != temp[1].length() ? 0 : temp[0].length() - firstNumFrom;
        String[] dbIndexes = new String[suffixTo - suffixFrom + 1];
        for (int i = suffixFrom; i <= suffixTo; ++i) {
            String dbIndex;
            dbIndexes[i] = dbIndex = header + StringUtil.alignRight(String.valueOf(i), suffixWidth, '0') + footer;
        }
        return dbIndexes;
    }

    private static int firstNum(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') continue;
            return i;
        }
        return -1;
    }

    private static int firstNot0(String str, int start) {
        for (int i = start; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '0') continue;
            return i;
        }
        return -1;
    }
}

