/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.DataTypeUtilities;
import com.oceanbase.jdbc.extend.datatype.Datum;
import java.math.BigDecimal;
import java.sql.SQLException;

public class BINARY_FLOAT
extends Datum {
    @Override
    public Object toJdbc() throws SQLException {
        return new Float(DataTypeUtilities.bytesToFloat(this.getBytes()));
    }

    @Override
    public boolean isConvertibleTo(Class targetClass) {
        String className = targetClass.getName();
        return className.compareTo("java.lang.String") == 0 || className.compareTo("java.lang.Float") == 0;
    }

    @Override
    public Object makeJdbcArray(int intVal) {
        return new Float[intVal];
    }

    @Override
    public String stringValue() {
        return Float.toString(DataTypeUtilities.bytesToFloat(this.getBytes()));
    }

    @Override
    public float floatValue() throws SQLException {
        return DataTypeUtilities.bytesToFloat(this.getBytes());
    }

    @Override
    public double doubleValue() throws SQLException {
        return this.floatValue();
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return new BigDecimal(this.floatValue());
    }

    public BINARY_FLOAT(float floatVal) {
        super(DataTypeUtilities.floatToBytes(floatVal));
    }

    public BINARY_FLOAT(Float floatVal) {
        super(DataTypeUtilities.floatToBytes(floatVal.floatValue()));
    }

    public BINARY_FLOAT(Boolean booleanVal) {
        this(booleanVal != false ? 1 : 0);
    }

    public BINARY_FLOAT(String stringVal) throws SQLException {
        this(DataTypeUtilities.stringToFloat(stringVal));
    }

    public BINARY_FLOAT(byte[] bytes) {
        super(bytes);
    }

    public BINARY_FLOAT() {
    }
}

