/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.IOException;

public class ByteArrayParameter
implements Cloneable,
ParameterHolder {
    private final byte[] bytes;
    private final boolean noBackslashEscapes;

    public ByteArrayParameter(byte[] bytes, boolean noBackslashEscapes) {
        this.bytes = bytes;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(BINARY_INTRODUCER);
        pos.writeBytesEscaped(this.bytes, this.bytes.length, this.noBackslashEscapes);
        pos.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return this.bytes.length * 2;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        pos.writeFieldLength(this.bytes.length);
        pos.write(this.bytes);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.VARSTRING;
    }

    @Override
    public String toString() {
        return "_binary '" + new String(this.bytes) + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

