/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.impl.checkers;

import com.oceanbase.jdbc.internal.failover.impl.checkers.ConfigChecker;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class BlackListStrategyAppendChecker
implements ConfigChecker {
    HashSet<String> keySet = new HashSet<String>(Arrays.asList("NAME", "RETRYTIMES", "DURATION"));
    HashSet<String> namesSet = new HashSet<String>(Arrays.asList("RETRYDURATION", "NORMAL"));

    @Override
    public boolean isValid(HashMap<String, String> config) {
        if (this.keySet.containsAll(config.keySet()) && this.namesSet.contains(config.get("NAME"))) {
            if (config.get("NAME") == "RETRYDURATION") {
                String retrytimes = config.get("RETRYTIMES");
                try {
                    int t = Integer.parseInt(retrytimes);
                    if (t < 0) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
                String duration = config.get("DURATION");
                try {
                    int t = Integer.parseInt(duration);
                    return t >= 0;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

