/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.offbytwo.jenkins.model.ParameterDefinitions;
import com.offbytwo.jenkins.model.ParametersDefinitionProperty;
import com.offbytwo.jenkins.model.StringParameterDefinition;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class JobConfiguration {
    private String configXml;
    private Document doc;
    private SAXReader reader;

    public JobConfiguration(String configXml) throws DocumentException {
        this.configXml = configXml;
        this.reader = new SAXReader();
        this.doc = this.reader.read((Reader)new StringReader(configXml));
    }

    public JobConfiguration addStringParam(String name, String desc, String defaultValue) throws JAXBException, DocumentException {
        List nodes = this.doc.selectNodes("//hudson.model.ParametersDefinitionProperty");
        StringWriter sw = new StringWriter();
        StringParameterDefinition spd = new StringParameterDefinition(name, desc, defaultValue);
        if (null == nodes || 0 == nodes.size()) {
            ParameterDefinitions pd = new ParameterDefinitions();
            pd.addParam(spd);
            ParametersDefinitionProperty pdp = new ParametersDefinitionProperty(pd);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ParametersDefinitionProperty.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)pdp, (Writer)sw);
            Document docInterlude = this.reader.read((Reader)new StringReader(sw.toString()));
            List propertiesNode = this.doc.selectNodes("//project/properties");
            for (Node node : propertiesNode) {
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                e.add(docInterlude.getRootElement());
            }
        } else {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{StringParameterDefinition.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)spd, (Writer)sw);
            Document docInterlude = this.reader.read((Reader)new StringReader(sw.toString()));
            List propertiesNode = this.doc.selectNodes("//parameterDefinitions");
            for (Node node : propertiesNode) {
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                e.add(docInterlude.getRootElement());
            }
        }
        return this;
    }

    public String asXml() {
        return this.doc.asXML();
    }

    public String getConfigXml() {
        return this.configXml;
    }

    public void setConfigXml(String configXml) {
        this.configXml = configXml;
    }
}

