/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http.httpclient;

import com.okta.commons.lang.Assert;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.api.DefaultClientCredentialsResolver;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.http.HttpHeaders;
import com.okta.sdk.impl.http.MediaType;
import com.okta.sdk.impl.http.Request;
import com.okta.sdk.impl.http.Response;
import com.okta.sdk.impl.http.RestException;
import com.okta.sdk.impl.http.RetryRequestExecutor;
import com.okta.sdk.impl.http.authc.DefaultRequestAuthenticatorFactory;
import com.okta.sdk.impl.http.authc.RequestAuthenticator;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.http.httpclient.HttpClientRequestFactory;
import com.okta.sdk.impl.http.support.DefaultResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestExecutor
extends RetryRequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestExecutor.class);
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 0x3FFFFFFF;
    private static final String MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxPerRoute";
    private static final int MAX_CONNECTIONS_PER_ROUTE = HttpClientRequestExecutor.parseConfigValue("com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxPerRoute", 0x3FFFFFFF, "Bad max connection per route value");
    private static final int DEFAULT_MAX_CONNECTIONS_TOTAL = Integer.MAX_VALUE;
    private static final String MAX_CONNECTIONS_TOTAL_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxTotal";
    private static final int MAX_CONNECTIONS_TOTAL = HttpClientRequestExecutor.parseConfigValue("com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxTotal", Integer.MAX_VALUE, "Bad max connection total value");
    private static final int DEFAULT_CONNECTION_VALIDATION_INACTIVITY = 2000;
    private static final String CONNECTION_VALIDATION_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.validateAfterInactivity";
    private static final int CONNECTION_VALIDATION_INACTIVITY = HttpClientRequestExecutor.parseConfigValue("com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.validateAfterInactivity", 2000, "Invalid max connection inactivity validation value");
    private static final int DEFAULT_CONNECTION_TIME_TO_LIVE = 300000;
    private static final String CONNECTION_TIME_TO_LIVE_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.timeToLive";
    private static final int CONNECTION_TIME_TO_LIVE = HttpClientRequestExecutor.parseConfigValue("com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.timeToLive", 300000, "Invalid connection time to live value");
    private final RequestAuthenticator requestAuthenticator;
    private HttpClient httpClient;
    private HttpClientRequestFactory httpClientRequestFactory;

    public HttpClientRequestExecutor(ClientConfiguration clientConfiguration) {
        super(clientConfiguration, null);
        ClientCredentials clientCredentials = clientConfiguration.getClientCredentialsResolver().getClientCredentials();
        Proxy proxy = clientConfiguration.getProxy();
        AuthenticationScheme authenticationScheme = clientConfiguration.getAuthenticationScheme();
        RequestAuthenticatorFactory requestAuthenticatorFactory = clientConfiguration.getRequestAuthenticatorFactory();
        Integer connectionTimeout = clientConfiguration.getConnectionTimeout();
        Assert.notNull((Object)clientCredentials, (String)"clientCredentials argument is required.");
        Assert.isTrue((connectionTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout cannot be a negative number.");
        RequestAuthenticatorFactory factory = requestAuthenticatorFactory != null ? requestAuthenticatorFactory : new DefaultRequestAuthenticatorFactory();
        this.requestAuthenticator = factory.create(authenticationScheme, clientCredentials);
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager((long)CONNECTION_TIME_TO_LIVE, TimeUnit.MILLISECONDS);
        connMgr.setValidateAfterInactivity(CONNECTION_VALIDATION_INACTIVITY);
        if (MAX_CONNECTIONS_TOTAL >= MAX_CONNECTIONS_PER_ROUTE) {
            connMgr.setDefaultMaxPerRoute(MAX_CONNECTIONS_PER_ROUTE);
            connMgr.setMaxTotal(MAX_CONNECTIONS_TOTAL);
        } else {
            connMgr.setDefaultMaxPerRoute(0x3FFFFFFF);
            connMgr.setMaxTotal(Integer.MAX_VALUE);
            log.warn("{} ({}) is less than {} ({}). Reverting to defaults: connectionMaxTotal ({}) and connectionMaxPerRoute ({}).", new Object[]{MAX_CONNECTIONS_TOTAL_PROPERTY_KEY, MAX_CONNECTIONS_TOTAL, MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY, MAX_CONNECTIONS_PER_ROUTE, Integer.MAX_VALUE, 0x3FFFFFFF});
        }
        int connectionTimeoutAsMilliseconds = connectionTimeout * 1000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeoutAsMilliseconds).setSocketTimeout(connectionTimeoutAsMilliseconds).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).disableCookieManagement().setDefaultConnectionConfig(connectionConfig).setConnectionManager((HttpClientConnectionManager)connMgr);
        this.httpClientRequestFactory = new HttpClientRequestFactory(requestConfig);
        if (proxy != null) {
            HttpHost httpProxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
            httpClientBuilder.setProxy(httpProxyHost);
            if (proxy.isAuthenticationRequired()) {
                AuthScope authScope = new AuthScope(proxy.getHost(), proxy.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
                BasicCredentialsProvider credentialsProviderProvider = new BasicCredentialsProvider();
                credentialsProviderProvider.setCredentials(authScope, (Credentials)credentials);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProviderProvider);
            }
        }
        httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        this.httpClient = httpClientBuilder.build();
    }

    private static ClientConfiguration createClientConfigration(ClientCredentials clientCredentials, Proxy proxy, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, Integer connectionTimeout) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setClientCredentialsResolver((ClientCredentialsResolver)new DefaultClientCredentialsResolver(clientCredentials));
        clientConfiguration.setProxy(proxy);
        clientConfiguration.setAuthenticationScheme(authenticationScheme);
        clientConfiguration.setRequestAuthenticatorFactory(requestAuthenticatorFactory);
        clientConfiguration.setConnectionTimeout(connectionTimeout.intValue());
        return clientConfiguration;
    }

    @Deprecated
    public HttpClientRequestExecutor(ClientCredentials clientCredentials, Proxy proxy, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, Integer connectionTimeout) {
        this(HttpClientRequestExecutor.createClientConfigration(clientCredentials, proxy, authenticationScheme, requestAuthenticatorFactory, connectionTimeout));
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Response doExecuteRequest(Request request) throws RestException {
        Assert.notNull((Object)request, (String)"Request argument cannot be null.");
        HttpResponse httpResponse = null;
        this.requestAuthenticator.authenticate(request);
        HttpRequestBase httpRequest = this.httpClientRequestFactory.createHttpClientRequest(request, null);
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            Response response = this.toSdkResponse(httpResponse);
            return response;
        }
        catch (SocketException | SocketTimeoutException | NoHttpResponseException | ConnectTimeoutException e) {
            throw new RestException("Unable to execute HTTP request - retryable exception: " + e.getMessage(), e, true);
        }
        catch (IOException e) {
            throw new RestException("Unable to execute HTTP request: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                httpResponse.getEntity().getContent().close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected byte[] toBytes(HttpEntity entity) throws IOException {
        return EntityUtils.toByteArray((HttpEntity)entity);
    }

    protected Response toSdkResponse(HttpResponse httpResponse) throws IOException {
        long contentLength;
        InputStream body;
        int httpStatus = httpResponse.getStatusLine().getStatusCode();
        HttpHeaders headers = this.getHeaders(httpResponse);
        MediaType mediaType = headers.getContentType();
        HttpEntity entity = this.getHttpEntity(httpResponse);
        InputStream inputStream = body = entity != null ? entity.getContent() : null;
        if (body != null) {
            byte[] bytes = this.toBytes(entity);
            contentLength = entity.getContentLength();
            body = bytes != null ? new ByteArrayInputStream(bytes) : null;
        } else {
            contentLength = 0L;
        }
        DefaultResponse response = new DefaultResponse(httpStatus, mediaType, body, contentLength);
        response.getHeaders().putAll((Map)headers);
        return response;
    }

    private HttpEntity getHttpEntity(HttpResponse response) {
        Header contentEncodingHeader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (contentEncodingHeader = entity.getContentEncoding()) != null) {
            for (HeaderElement element : contentEncodingHeader.getElements()) {
                if (!element.getName().equalsIgnoreCase("gzip")) continue;
                return new GzipDecompressingEntity(response.getEntity());
            }
        }
        return entity;
    }

    private HttpHeaders getHeaders(HttpResponse response) {
        HttpHeaders headers = new HttpHeaders();
        Header[] httpHeaders = response.getAllHeaders();
        if (httpHeaders != null) {
            for (Header httpHeader : httpHeaders) {
                headers.add(httpHeader.getName(), httpHeader.getValue());
            }
        }
        return headers;
    }

    private static int parseConfigValue(String key, int defaultValue, String warning) {
        int configuredValue = defaultValue;
        String configuredValueString = System.getProperty(key);
        if (configuredValueString != null) {
            try {
                configuredValue = Integer.parseInt(configuredValueString);
            }
            catch (NumberFormatException nfe) {
                log.warn("{}: {}. Using default: {}.", new Object[]{warning, configuredValueString, defaultValue, nfe});
            }
        }
        return configuredValue;
    }
}

