/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import java.sql.ShardingKey;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import oracle.jdbc.AccessToken;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleConnectionBuilder;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc.pool")
@Supports(value={Feature.CONN_POOL})
public abstract class OracleConnectionBuilderImpl
implements OracleConnectionBuilder {
    protected String user = null;
    protected String password = null;
    protected String serviceName = null;
    protected String instanceName = null;
    protected OracleShardingKey shardingKey = null;
    protected OracleShardingKey superShardingKey = null;
    protected SSLContext sslContext = null;
    protected Supplier<? extends AccessToken> tokenSupplier = null;
    protected GSSCredential gssCredential = null;

    @Override
    public abstract OracleConnection build() throws SQLException;

    @Override
    public OracleConnectionBuilderImpl password(@Blind String string) {
        this.password = string;
        return this;
    }

    @Override
    public OracleConnectionBuilderImpl user(String string) {
        this.user = string;
        return this;
    }

    public OracleConnectionBuilderImpl serviceName(String string) {
        this.serviceName = string;
        return this;
    }

    public OracleConnectionBuilderImpl instanceName(String string) {
        this.instanceName = string;
        return this;
    }

    @Override
    public OracleConnectionBuilderImpl shardingKey(OracleShardingKey oracleShardingKey) {
        this.shardingKey = oracleShardingKey;
        return this;
    }

    @Override
    public OracleConnectionBuilderImpl superShardingKey(OracleShardingKey oracleShardingKey) {
        this.superShardingKey = oracleShardingKey;
        if (oracleShardingKey != null) {
            ((OracleShardingKeyImpl)oracleShardingKey).markSuperShardingKey(true);
        }
        return this;
    }

    @Override
    public OracleConnectionBuilderImpl shardingKey(ShardingKey shardingKey) {
        return this.shardingKey((OracleShardingKey)shardingKey);
    }

    @Override
    public OracleConnectionBuilderImpl superShardingKey(ShardingKey shardingKey) {
        return this.superShardingKey((OracleShardingKey)shardingKey);
    }

    @Override
    public OracleConnectionBuilderImpl gssCredential(GSSCredential gSSCredential) {
        if (gSSCredential == null) {
            throw new NullPointerException();
        }
        this.gssCredential = gSSCredential;
        return this;
    }

    @Override
    public OracleConnectionBuilderImpl sslContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
        return this;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    public String getUser() {
        return this.user;
    }

    @Blind
    public String getPassword() {
        return this.password;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public OracleShardingKeyImpl getShardingKey() {
        return (OracleShardingKeyImpl)this.shardingKey;
    }

    public OracleShardingKeyImpl getSuperShardingKey() {
        return (OracleShardingKeyImpl)this.superShardingKey;
    }

    @Blind
    public GSSCredential getGSSCredential() {
        return this.gssCredential;
    }

    @Override
    public final OracleConnectionBuilderImpl accessToken(@Blind AccessToken accessToken) {
        Objects.requireNonNull(accessToken, "Value of accessToken is null");
        this.setTokenSupplier(() -> accessToken);
        return this;
    }

    public final void setTokenSupplier(@Blind Supplier<? extends AccessToken> supplier) {
        this.tokenSupplier = supplier;
    }

    @Blind
    public final Supplier<? extends AccessToken> getTokenSupplier() {
        return this.tokenSupplier;
    }

    public final void verifyBuildConfiguration() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.getUser() != null || this.getPassword() != null;
        if (this.getGSSCredential() != null && bl) {
            throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
        }
        if (this.tokenSupplier != null && bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Builder is configured with both an access token and a user name or password").fillInStackTrace();
        }
    }
}

