/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.Topology;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;

public class CoreConnectionImpl
implements CoreConnection,
Diagnosable {
    static final String CLASS_NAME = CoreConnectionImpl.class.getName();
    private static final long CLOSE_TIMEOUT = 5000L;
    private static final short DB_VERSION_122 = 12200;
    private volatile Service service;
    private final UniversalPooledConnection upc;
    private final Properties props;
    private volatile ServiceMember serviceMember;
    private boolean replayable = false;
    private AtomicBoolean pendingClose = new AtomicBoolean(false);
    private final Topology connectionSource;
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private final Semaphore acSemaphore = new Semaphore(1);

    static CoreConnection create(Service service, Object delegate, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        return new CoreConnectionImpl(service, delegate, diagnosticsCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnectionImpl(final Service service, Object delegate, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        this.service = Objects.requireNonNull(service);
        this.connectionSource = Objects.requireNonNull(this.service.connectionSource());
        this.upc = (UniversalPooledConnection)Objects.requireNonNull(delegate);
        this.props = this.upc.getDatabaseConnectionProperties();
        this.serviceMember = new ServiceMember(this.props, service);
        this.diagnosticsCollector = diagnosticsCollector;
        this.trace(Level.FINE, CLASS_NAME, "<init>", "about to create a new connection, connStats={0}", null, null, this.connStats());
        try {
            String smServiceName = this.serviceMember.service();
            assert (this.service.isThisServiceName(smServiceName));
            service.setContainerName(this.fetchContainerName());
            service.placement.addAll(this.fetchServicePlacement());
            final String[] onsConfig = new String[]{this.connectionSource.getONSConfig()};
            if (null == onsConfig[0] || "".equals(onsConfig[0])) {
                onsConfig[0] = this.props.getProperty("AUTH_ONS_CONFIG");
            }
            if (this.connectionSource.failoverEnabled() && service.onsStarted.compareAndSet(false, true)) {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                    @Override
                    public void run() {
                        block4: {
                            CoreConnectionImpl.this.trace(Level.FINE, CLASS_NAME, "<init>", "failover enabled - about to start ONS", null, null, new Object[0]);
                            try {
                                ONSDriver onsDriver = CoreConnectionImpl.this.connectionSource.onsDriver(onsConfig[0]);
                                if (onsDriver != null) {
                                    service.failoverDriver.start(onsDriver);
                                    String serviceName = CoreConnectionImpl.this.serviceMember.service();
                                    if (null != serviceName) {
                                        service.loadBalancer.start(onsDriver, serviceName);
                                    }
                                }
                                CoreConnectionImpl.this.trace(Level.FINE, CLASS_NAME, "<init>", "ONS started", null, null, new Object[0]);
                            }
                            catch (Throwable e) {
                                UniversalPooledConnectionImpl upc;
                                UniversalConnectionPoolBase ucp;
                                CoreConnectionImpl.this.trace(Level.WARNING, CLASS_NAME, "<init>", "", null, e, new Object[0]);
                                CoreConnectionImpl.this.trace(Level.SEVERE, CLASS_NAME, ":<init>", "ONS registration failed, disabling FAN/FCF: all applicable subsystems, like Fast Failover, Runtime Load Balancing and Sharding Configuration Updates will not work properly", null, null, new Object[0]);
                                Object delegate = CoreConnectionImpl.this.getDelegate();
                                if (!Objects.nonNull(delegate) || !(delegate instanceof UniversalPooledConnectionImpl) || !Objects.nonNull(ucp = (upc = (UniversalPooledConnectionImpl)delegate).getPool())) break block4;
                                ucp.setFailoverEnabled(false);
                            }
                        }
                    }

                    @Override
                    public boolean isCritical() {
                        return true;
                    }
                });
            }
            this.serviceMember = service.insertMember(this.serviceMember);
            this.serviceMember.activeCount.incrementAndGet();
            this.serviceMember.serviceRef.lbStats.onOpened();
            this.serviceMember.lbStats.onOpened();
            this.connectionSource.totalCount().incrementAndGet();
            this.serviceMember.serviceRef.activeCount.incrementAndGet();
            this.connectionSource.totalCount(this.upc.getConnectionRetrievalInfo()).incrementAndGet();
            if (this.connectionSource.isDataDependentRoutingEnabled()) {
                ONSDriver onsDrvr = this.connectionSource.onsDriver(onsConfig[0]);
                service.routingCache().startEventHandler(onsDrvr);
                service.routingCache().onConnectionCreation((Connection)this.getPhysicalConnection(), this.cri());
            }
            service.onRegister();
        }
        catch (Throwable throwable) {
            this.trace(Level.FINE, CLASS_NAME, "<init>", "created: connStats={0}", null, null, this.connStats());
            throw throwable;
        }
        this.trace(Level.FINE, CLASS_NAME, "<init>", "created: connStats={0}", null, null, this.connStats());
    }

    void setRepurposedService(Service repurposedService) {
        assert (Objects.nonNull(this.service));
        this.service = Objects.requireNonNull(repurposedService);
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void makeAvailable() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "makeAvailable", "entering args ()", null, null, new Object[0]);
            this.upc.heartbeat();
            this.upc.setAvailableStartTime();
            try {
                this.upc.removeConnectionHarvestingCallback();
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "makeAvailable", "", null, e, new Object[0]);
            }
            if (this.upc.setAvailable()) {
                long delta = Clock.clock() - this.upc.getBorrowedStartTime();
                this.serviceMember.serviceRef.lbStats.onReturned(delta);
                this.serviceMember.lbStats.onReturned(delta);
                this.serviceMember.borrowedCount.decrementAndGet();
                this.connectionSource.borrowedCount().decrementAndGet();
                this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
                this.connectionSource.cumulativeConnectionUseTime().addAndGet(delta);
                this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "makeAvailable", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "makeAvailable", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void makeUnavailable() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "makeUnavailable", "entering args ()", null, null, new Object[0]);
            this.upc.heartbeat();
            this.upc.setBorrowedStartTime();
            if (this.upc.setBorrowed()) {
                this.serviceMember.lbStats.onBorrowed(this.serviceMember.borrowedCount.incrementAndGet());
                this.serviceMember.serviceRef.lbStats.onBorrowed(this.connectionSource.borrowedCount().incrementAndGet());
                this.serviceMember.serviceRef.borrowedCount.incrementAndGet();
                this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).incrementAndGet();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "makeUnavailable", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "makeUnavailable", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void markReconnecting() {
        try {
            block13: {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markReconnecting", "entering args ()", null, null, new Object[0]);
                if (this.normal()) {
                    String origInst = this.serviceMember().name();
                    try {
                        this.acSemaphore.acquire();
                        if (origInst == null || !origInst.equals(this.serviceMember().name())) break block13;
                        try {
                            this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                        }
                        catch (UniversalConnectionPoolException e) {
                            this.trace(Level.WARNING, CLASS_NAME, "markReconnecting", "", null, e, new Object[0]);
                        }
                        finally {
                            this.abort();
                            this.close();
                        }
                    }
                    catch (InterruptedException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "markReconnecting", "", null, e, new Object[0]);
                    }
                    finally {
                        this.acSemaphore.release();
                    }
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markReconnecting", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markReconnecting", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void reinitialize() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reinitialize", "entering args ()", null, null, new Object[0]);
            try {
                this.acSemaphore.acquire();
                boolean avail = this.available();
                ServiceMember oldInst = this.serviceMember();
                Properties props = this.upc.getDatabaseConnectionProperties();
                this.serviceMember = new ServiceMember(props, this.service);
                this.serviceMember = this.service.insertMember(this.serviceMember);
                this.serviceMember.activeCount.incrementAndGet();
                if (!avail) {
                    this.serviceMember.borrowedCount.incrementAndGet();
                }
                this.serviceMember.lbStats.onOpened();
                this.serviceMember.serviceRef.lbStats.onOpened();
                oldInst.activeCount.decrementAndGet();
                oldInst.lbStats.onClosed();
                oldInst.serviceRef.lbStats.onClosed();
                if (!avail) {
                    oldInst.borrowedCount.decrementAndGet();
                }
                try {
                    this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_NORMAL);
                }
                catch (UniversalConnectionPoolException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "reinitialize", "", null, e, new Object[0]);
                }
            }
            catch (InterruptedException e) {
                this.trace(Level.WARNING, CLASS_NAME, "reinitialize", "", null, e, new Object[0]);
            }
            finally {
                this.acSemaphore.release();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reinitialize", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reinitialize", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public boolean repurpose(ConnectionRetrievalInfo var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public CompletionStage<Boolean> repurposeAsync(ConnectionRetrievalInfo connectionRetrievalInfo, Executor executor) {
        try {
            void newCri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "repurposeAsync", "entering args ({0}, {1})", null, null, connectionRetrievalInfo, executor);
            final CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            if (!(this.cri() instanceof JDBCConnectionRetrievalInfo)) {
                cf.complete(false);
                CompletableFuture<Boolean> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "repurposeAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            if (!(newCri instanceof JDBCConnectionRetrievalInfo)) {
                cf.complete(false);
                CompletableFuture<Boolean> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "repurposeAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            if (!(this.cri() instanceof JDBCConnectionRetrievalInfo)) {
                cf.complete(false);
                CompletableFuture<Boolean> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "repurposeAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            if (this.closed() || !this.valid()) {
                cf.complete(false);
                CompletableFuture<Boolean> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "repurposeAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
            if (oConn == null) {
                cf.complete(false);
                CompletableFuture<Boolean> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "repurposeAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            final JDBCConnectionRetrievalInfo repurposeCri = (JDBCConnectionRetrievalInfo)newCri;
            String repurposeSvcName = repurposeCri.getServiceName();
            final JDBCConnectionRetrievalInfo connCri = (JDBCConnectionRetrievalInfo)this.cri();
            if (!repurposeCri.equals(connCri.getCopyWithService(repurposeSvcName))) {
                cf.complete(false);
                CompletableFuture<Boolean> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "repurposeAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            try {
                final Service newSvc = this.connectionSource.getServiceByName(repurposeSvcName);
                String setContainerStr = "alter session set container=" + newSvc.containerName() + " service=\"" + newSvc.getLogicalServiceName() + "\"";
                final PreparedStatement preparedStatement = oConn.prepareStatement(setContainerStr);
                Flow.Publisher repurposerStmtPublisher = preparedStatement.unwrap(OraclePreparedStatement.class).executeAsyncOracle();
                final CoreConnectionImpl outerThis = this;
                repurposerStmtPublisher.subscribe(new Flow.Subscriber<Boolean>(){

                    @Override
                    public void onSubscribe(Flow.Subscription subscription) {
                        subscription.request(1L);
                    }

                    @Override
                    public void onNext(Boolean item) {
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        this.closeStatement();
                        cf.completeExceptionally(throwable);
                    }

                    @Override
                    public void onComplete() {
                        this.closeStatement();
                        String newContainerName = newSvc.containerName();
                        Properties connProps = CoreConnectionImpl.this.upc.getDatabaseConnectionProperties();
                        String newServiceName = connProps.getProperty("SERVICE_NAME");
                        if (!newSvc.isThisServiceName(newServiceName) && !newSvc.containerName().equalsIgnoreCase(newContainerName)) {
                            CoreConnectionImpl.this.trace(Level.WARNING, CLASS_NAME, "repurposeAsync", "Repurposing connection from service {0} to service {1} failed", null, null, CoreConnectionImpl.this.serviceName(), newSvc.getFullServiceName());
                            cf.complete(false);
                            return;
                        }
                        CoreConnectionImpl.this.trace(Level.INFO, CLASS_NAME, "repurposeAsync", "Repurposed connection from service {0} to service {1}", null, null, CoreConnectionImpl.this.serviceName(), newSvc.getFullServiceName());
                        if (CoreConnectionImpl.this.getDelegate() instanceof OracleUniversalPooledConnection) {
                            OracleUniversalPooledConnection jdbcConn = (OracleUniversalPooledConnection)CoreConnectionImpl.this.getDelegate();
                            jdbcConn.setPdbSessionInitialized(false);
                            CoreConnectionImpl.this.connectionSource.totalCount(connCri).decrementAndGet();
                            JDBCConnectionRetrievalInfo repurposedCri = repurposeCri.getCopyWithService(newServiceName).getCopyWithNoLabels();
                            jdbcConn.setConnectionRetrievalInfo(repurposedCri);
                            outerThis.setRepurposedService(newSvc);
                            CoreConnectionImpl.this.connectionSource.totalCount(repurposedCri).incrementAndGet();
                        }
                        CoreConnectionImpl.this.serviceMember.activeCount.decrementAndGet();
                        CoreConnectionImpl.this.serviceMember.lbStats.onClosed();
                        CoreConnectionImpl.this.serviceMember.serviceRef.activeCount.decrementAndGet();
                        CoreConnectionImpl.this.serviceMember.serviceRef.lbStats.onClosed();
                        CoreConnectionImpl.this.serviceMember = new ServiceMember(connProps, newSvc);
                        CoreConnectionImpl.this.serviceMember = newSvc.insertMember(CoreConnectionImpl.this.serviceMember);
                        CoreConnectionImpl.this.serviceMember.activeCount.incrementAndGet();
                        newSvc.lbStats.onOpened();
                        CoreConnectionImpl.this.serviceMember.lbStats.onOpened();
                        newSvc.activeCount.incrementAndGet();
                        cf.complete(true);
                    }

                    private void closeStatement() {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException closeException) {
                            cf.completeExceptionally(closeException);
                        }
                    }
                });
            }
            catch (SQLException e) {
                cf.completeExceptionally(e);
            }
            CompletableFuture<Boolean> completableFuture = cf;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "repurposeAsync", "returning {0}", null, null, completableFuture);
            return completableFuture;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "repurposeAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private String connStats() {
        String totalStats = "(borrowed=" + this.connectionSource.borrowedCount().get() + ", total=" + this.connectionSource.totalCount().get() + ")";
        String serviceStats = "(service=" + this.service.getFullServiceName() + ", borrowed=" + this.service.borrowedCount.get() + ", total=" + this.service.activeCount.get() + ")";
        String serviceMemberStats = "(serviceMember:" + this.service.getAllMembers().toString() + ")";
        return totalStats + ", " + serviceStats + ", " + serviceMemberStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void close() {
        try {
            block23: {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "close", "entering args ()", null, null, new Object[0]);
                try {
                    this.trace(Level.FINE, CoreConnectionImpl.CLASS_NAME, "close", "about to close conn={0}, connStats={1}", null, null, new Object[]{this, this.connStats()});
                    while (true) {
                        current = ((UniversalPooledConnectionImpl)this.upc).m_status.get();
                        if (UniversalPooledConnectionStatus.STATUS_CLOSED.equals(current) && ((UniversalPooledConnectionImpl)this.upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED)) {
                        }
                        ** GOTO lbl-1000
                        break;
                    }
                }
                catch (Throwable var5_7) {
                    this.trace(Level.FINE, CoreConnectionImpl.CLASS_NAME, "close", "closed conn={0}, connStats={1}", null, null, new Object[]{this, this.connStats()});
                    throw var5_7;
                }
                this.trace(Level.FINE, CoreConnectionImpl.CLASS_NAME, "close", "closed conn={0}, connStats={1}", null, null, new Object[]{this, this.connStats()});
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "close", "returning void", null, null, new Object[0]);
                return;
lbl-1000:
                // 1 sources

                {
                    if (UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(current) && ((UniversalPooledConnectionImpl)this.upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_RECONNECTING)) {
                        reconnecting = true;
                    } else {
                        if (!((UniversalPooledConnectionImpl)this.upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED)) ** continue;
                        reconnecting = false;
                    }
                    if (!this.available() && !reconnecting) {
                        delta = Clock.clock() - this.upc.getBorrowedStartTime();
                        this.serviceMember.serviceRef.lbStats.onReturned(delta);
                        this.serviceMember.lbStats.onReturned(delta);
                        this.serviceMember.borrowedCount.decrementAndGet();
                        this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
                        this.connectionSource.borrowedCount().decrementAndGet();
                        this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
                        this.connectionSource.cumulativeConnectionUseTime().addAndGet(delta);
                        try {
                            if (this.connectionSource.isDataDependentRoutingEnabled()) {
                                this.service.routingCache().onConnectionReturn((Connection)this.getPhysicalConnection());
                            }
                        }
                        catch (SQLException e) {
                            this.trace(Level.WARNING, CoreConnectionImpl.CLASS_NAME, "close", "", null, e, new Object[0]);
                        }
                    }
                    if (this.connectionSource.isDataDependentRoutingEnabled()) {
                        this.service.routingCache().onConnectionClosure((Connection)this.getPhysicalConnection());
                    }
                    if (!reconnecting) {
                        this.serviceMember.activeCount.decrementAndGet();
                        this.serviceMember.serviceRef.activeCount.decrementAndGet();
                        this.serviceMember.serviceRef.lbStats.onClosed();
                        this.serviceMember.lbStats.onClosed();
                        this.connectionSource.totalCount().decrementAndGet();
                        this.connectionSource.totalCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
                        this.connectionSource.connectionsClosed().incrementAndGet();
                    }
                    if (this.pendingClose.compareAndSet(true, false)) {
                        this.serviceMember.pendingCloseCount.decrementAndGet();
                        this.serviceMember.serviceRef.pendingCloseCount.decrementAndGet();
                    }
                    if (this.bad() || this.reconnecting()) {
                        this.abort();
                        break block23;
                    }
                    try {
                        submittedTask = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                            @Override
                            public void run() {
                                ((UniversalPooledConnectionImpl)CoreConnectionImpl.this.upc).closeNoStatsUpdate();
                            }
                        });
                        if (submittedTask != null) {
                            submittedTask.get(5000L);
                            submittedTask.getTask().release();
                        } else {
                            this.trace(Level.WARNING, CoreConnectionImpl.CLASS_NAME, "close", "task submission failed", null, null, new Object[0]);
                        }
                        if (!this.closed()) {
                            ((UniversalPooledConnectionImpl)this.upc).m_status.set(UniversalPooledConnectionStatus.STATUS_BAD);
                            this.abort();
                        } else {
                            ((UniversalPooledConnectionImpl)this.upc).m_status.set(UniversalPooledConnectionStatus.STATUS_CLOSED);
                        }
                    }
                    catch (TaskManagerException e) {
                        this.trace(Level.WARNING, CoreConnectionImpl.CLASS_NAME, "close", "", null, e, new Object[0]);
                    }
                }
            }
            this.trace(Level.FINE, CoreConnectionImpl.CLASS_NAME, "close", "closed conn={0}, connStats={1}", null, null, new Object[]{this, this.connStats()});
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "close", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable var6_8) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "close", "throwing", null, var6_8, new Object[0]);
            throw var6_8;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public CompletionStage<Void> closeAsync(Executor executor) {
        try {
            boolean reconnecting;
            CompletableFuture<Void> cf;
            block10: {
                UniversalPooledConnectionStatus current;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeAsync", "entering args ({0})", null, null, executor);
                cf = new CompletableFuture<Void>();
                this.trace(Level.FINE, CLASS_NAME, "closeAsync", "about to close conn={0}, connStats={1}", null, null, this, this.connStats());
                do {
                    if (UniversalPooledConnectionStatus.STATUS_CLOSED.equals(current = ((UniversalPooledConnectionImpl)this.upc).m_status.get()) && ((UniversalPooledConnectionImpl)this.upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED)) {
                        cf.complete(null);
                        CompletableFuture<Void> completableFuture = cf;
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeAsync", "returning {0}", null, null, completableFuture);
                        return completableFuture;
                    }
                    if (!UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(current) || !((UniversalPooledConnectionImpl)this.upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_RECONNECTING)) continue;
                    reconnecting = true;
                    break block10;
                } while (!((UniversalPooledConnectionImpl)this.upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED));
                reconnecting = false;
            }
            if (!this.available() && !reconnecting) {
                long delta = Clock.clock() - this.upc.getBorrowedStartTime();
                this.serviceMember.serviceRef.lbStats.onReturned(delta);
                this.serviceMember.lbStats.onReturned(delta);
                this.serviceMember.borrowedCount.decrementAndGet();
                this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
                this.connectionSource.borrowedCount().decrementAndGet();
                this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
                this.connectionSource.cumulativeConnectionUseTime().addAndGet(delta);
            }
            if (this.connectionSource.isDataDependentRoutingEnabled()) {
                this.service.routingCache().onConnectionClosure((Connection)this.getPhysicalConnection());
            }
            if (!reconnecting) {
                this.serviceMember.activeCount.decrementAndGet();
                this.serviceMember.serviceRef.activeCount.decrementAndGet();
                this.serviceMember.serviceRef.lbStats.onClosed();
                this.serviceMember.lbStats.onClosed();
                this.connectionSource.totalCount().decrementAndGet();
                this.connectionSource.totalCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
                this.connectionSource.connectionsClosed().incrementAndGet();
            }
            if (this.pendingClose.compareAndSet(true, false)) {
                this.serviceMember.pendingCloseCount.decrementAndGet();
                this.serviceMember.serviceRef.pendingCloseCount.decrementAndGet();
            }
            if (this.bad() || this.reconnecting()) {
                this.abort();
                cf.complete(null);
            } else {
                void executor2;
                ((UniversalPooledConnectionImpl)this.upc).closeNoStatsUpdateAsync((Executor)executor2).toCompletableFuture().orTimeout(5000L, TimeUnit.MILLISECONDS).whenCompleteAsync((p, e) -> {
                    if (!this.closed()) {
                        ((UniversalPooledConnectionImpl)this.upc).m_status.set(UniversalPooledConnectionStatus.STATUS_BAD);
                        this.abort();
                        cf.complete(null);
                    } else {
                        ((UniversalPooledConnectionImpl)this.upc).m_status.set(UniversalPooledConnectionStatus.STATUS_CLOSED);
                    }
                    if (Objects.nonNull(e)) {
                        cf.completeExceptionally((Throwable)e);
                        return;
                    }
                    cf.complete(null);
                }, (Executor)executor2);
            }
            CompletableFuture<Void> completableFuture = cf;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeAsync", "returning {0}", null, null, completableFuture);
            return completableFuture;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void cleanupToHarvest() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "cleanupToHarvest", "entering args ()", null, null, new Object[0]);
            try {
                ConnectionHarvestingCallback callback = this.upc.getConnectionHarvestingCallback();
                if (callback != null) {
                    callback.cleanup();
                }
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "cleanupToHarvest", "", null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "cleanupToHarvest", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "cleanupToHarvest", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public boolean reconnecting() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reconnecting", "entering args ()", null, null, new Object[0]);
            boolean bl = UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(this.upc.getStatus());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reconnecting", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reconnecting", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void markCloseOnReturn() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markCloseOnReturn", "entering args ()", null, null, new Object[0]);
            try {
                this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "markCloseOnReturn", "", null, null, new Object[0]);
            }
            if (this.pendingClose.compareAndSet(false, true)) {
                this.serviceMember.pendingCloseCount.incrementAndGet();
                this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markCloseOnReturn", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markCloseOnReturn", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void markToReplace() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markToReplace", "entering args ()", null, null, new Object[0]);
            try {
                this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "markToReplace", "", null, null, new Object[0]);
            }
            if (this.pendingClose.compareAndSet(false, true)) {
                this.serviceMember.pendingCloseCount.incrementAndGet();
                this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markToReplace", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markToReplace", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public ConnectionRetrievalInfo cri() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "cri", "entering args ()", null, null, new Object[0]);
            ConnectionRetrievalInfo connectionRetrievalInfo = this.upc.getConnectionRetrievalInfo();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "cri", "returning {0}", null, null, connectionRetrievalInfo);
            return connectionRetrievalInfo;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "cri", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Object getDelegate() {
        return this.upc;
    }

    @Override
    public boolean available() {
        return this.upc.isAvailable();
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void abort() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "abort", "entering args ()", null, null, new Object[0]);
            this.trace(Level.INFO, CLASS_NAME, "abort", "about to abort conn={0}, connStats={1}", null, null, this, this.connStats());
            this.upc.abort();
            this.serviceMember.serviceRef.lbStats.onAborted();
            this.serviceMember.lbStats.onAborted();
            this.trace(Level.INFO, CLASS_NAME, "abort", "aborted conn={0}, connStats={1}", null, null, this, this.connStats());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "abort", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "abort", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public long lastAccessedTime() {
        return this.upc.getLastAccessedTime();
    }

    @Override
    public boolean reusable() {
        return this.upc.isReusable();
    }

    @Override
    public boolean valid() {
        return this.upc.isValid();
    }

    @Override
    public boolean closed() {
        return UniversalPooledConnectionStatus.STATUS_CLOSED.equals(this.upc.getStatus());
    }

    @Override
    public boolean bad() {
        return UniversalPooledConnectionStatus.STATUS_BAD.equals(this.upc.getStatus());
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void markBad() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markBad", "entering args ()", null, null, new Object[0]);
            try {
                this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "markBad", "", null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markBad", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markBad", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean normal() {
        return UniversalPooledConnectionStatus.STATUS_NORMAL.equals(this.upc.getStatus());
    }

    @Override
    public boolean markedToReplace() {
        return UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN.equals(this.upc.getStatus());
    }

    @Override
    public boolean markedCloseOnReturn() {
        return UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN.equals(this.upc.getStatus());
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public ServiceMember serviceMember() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "serviceMember", "entering args ()", null, null, new Object[0]);
            if (null == this.serviceMember || null == this.serviceMember.name()) {
                throw new IllegalStateException();
            }
            ServiceMember serviceMember = this.serviceMember;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "serviceMember", "returning {0}", null, null, serviceMember);
            return serviceMember;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "serviceMember", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void handleTimeout() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "handleTimeout", "entering args ()", null, null, new Object[0]);
            this.upc.handleTimeout();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "handleTimeout", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "handleTimeout", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public int labelingCost(Properties properties) {
        try {
            void reqLabels;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "labelingCost", "entering args ({0})", null, null, properties);
            int n = this.upc.labelingCost((Properties)reqLabels);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "labelingCost", "returning {0}", null, null, n);
            return n;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "labelingCost", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean isReplayable() {
        return this.replayable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setReplayable(boolean bl) {
        try {
            void replayable;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "setReplayable", "entering args ({0})", null, null, bl);
            this.replayable = replayable;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "setReplayable", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "setReplayable", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String serviceName() {
        return this.serviceMember.service();
    }

    @Override
    public Service service() {
        return this.service;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onError(int n) {
        try {
            void oraErrorNumber;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onError", "entering args ({0})", null, null, n);
            UniversalPooledConnectionImpl upc = (UniversalPooledConnectionImpl)this.getDelegate();
            this.service.routingCache().onError((int)oraErrorNumber, upc.getBorrowCRI(), this.serviceMember());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onError", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onError", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onInsert() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onInsert", "entering args ()", null, null, new Object[0]);
            ((UniversalPooledConnectionImpl)this.getDelegate()).onInsert();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onInsert", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onInsert", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onRetrieve() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onRetrieve", "entering args ()", null, null, new Object[0]);
            ((UniversalPooledConnectionImpl)this.getDelegate()).onRetrieve();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onRetrieve", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onRetrieve", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onBorrow(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onBorrow", "entering args ({0})", null, null, connectionRetrievalInfo);
            try {
                void cri;
                if (this.connectionSource.isDataDependentRoutingEnabled()) {
                    this.service.routingCache().onConnectionBorrow((Connection)this.getPhysicalConnection(), (ConnectionRetrievalInfo)cri);
                }
                if (this.connectionSource.isMultitenantDatabase() && this.upc instanceof OracleUniversalPooledConnection) {
                    ((OracleUniversalPooledConnection)this.upc).initPdbSession((ConnectionRetrievalInfo)cri);
                }
                this.openProxySession((ConnectionRetrievalInfo)cri);
            }
            catch (SQLException e) {
                throw new UniversalConnectionPoolException(e.getMessage(), e);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onBorrow", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onBorrow", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onReturn() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onReturn", "entering args ()", null, null, new Object[0]);
            try {
                if (this.service.connectionSource().isDataDependentRoutingEnabled()) {
                    this.service.routingCache().onConnectionReturn((Connection)this.getPhysicalConnection());
                }
                this.closeProxySession();
            }
            catch (SQLException e) {
                throw new UniversalConnectionPoolException(e.getMessage(), e);
            }
            this.commit();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onReturn", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onReturn", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void commit() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "commit", "entering args ()", null, null, new Object[0]);
            this.commitRollbackHelper(false);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "commit", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "commit", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void rollback() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "rollback", "entering args ()", null, null, new Object[0]);
            this.commitRollbackHelper(true);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "rollback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "rollback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private void commitRollbackHelper(boolean rollback) {
        if (this.upc.isOracle()) {
            OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
            if (oConn == null) {
                return;
            }
            EnumSet tstate = null;
            try {
                tstate = oConn.getTransactionState();
            }
            catch (SQLException e) {
                this.trace(Level.FINEST, CLASS_NAME, "commitRollbackHelper", "failed to determine transaction state", null, e, new Object[0]);
            }
            if (tstate == null) {
                try {
                    if (!oConn.getAutoCommit()) {
                        this.doCommitRollback(oConn, rollback);
                    }
                }
                catch (SQLException e) {
                    this.trace(Level.FINEST, CLASS_NAME, "commitRollbackHelper", "failed to determine auto commit mode", null, e, new Object[0]);
                }
            } else if (tstate.contains(OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                this.doCommitRollback(oConn, rollback);
            }
        }
    }

    private void doCommitRollback(OracleConnection oConn, boolean rollback) {
        try {
            if (rollback) {
                oConn.rollback();
                this.trace(Level.FINEST, CLASS_NAME, "doCommitRollback", "successfully rolled back", null, null, new Object[0]);
            } else {
                oConn.commit();
                this.trace(Level.FINEST, CLASS_NAME, "doCommitRollback", "successfully committed", null, null, new Object[0]);
            }
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "doCommitRollback", "failed to {0} unfinished transaction", null, e, rollback ? "rollback" : "commit");
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public Object getPhysicalConnection() {
        try {
            block11: {
                Object object;
                Object conn;
                block8: {
                    block10: {
                        block9: {
                            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "getPhysicalConnection", "entering args ()", null, null, new Object[0]);
                            Object delegate = Objects.requireNonNull(this.getDelegate());
                            if (!(delegate instanceof UniversalPooledConnection)) {
                                Object var5_2 = null;
                                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "getPhysicalConnection", "returning {0}", null, null, var5_2);
                                return var5_2;
                            }
                            UniversalPooledConnection upc = (UniversalPooledConnection)delegate;
                            conn = upc.getPhysicalConnection();
                            if (!upc.isOracle()) break block8;
                            if (!(conn instanceof OracleConnection)) break block9;
                            Object object2 = conn;
                            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "getPhysicalConnection", "returning {0}", null, null, object2);
                            return object2;
                        }
                        if (!(conn instanceof OracleXAConnection)) break block10;
                        Connection connection = ((OracleXAConnection)conn).getPhysicalHandle();
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "getPhysicalConnection", "returning {0}", null, null, connection);
                        return connection;
                    }
                    if (!(conn instanceof OraclePooledConnection)) break block11;
                    Connection connection = ((OraclePooledConnection)conn).getConnection();
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "getPhysicalConnection", "returning {0}", null, null, connection);
                    return connection;
                }
                try {
                    object = conn;
                }
                catch (SQLException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "getPhysicalConnection", "", null, null, new Object[0]);
                }
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "getPhysicalConnection", "returning {0}", null, null, object);
                return object;
            }
            Object var5_7 = null;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "getPhysicalConnection", "returning {0}", null, null, var5_7);
            return var5_7;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "getPhysicalConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private void openProxySession(ConnectionRetrievalInfo connectionRetrievalInfo) throws SQLException {
        try {
            void borrowCri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "openProxySession", "entering args ({0})", null, null, connectionRetrievalInfo);
            if (!(borrowCri instanceof JDBCConnectionRetrievalInfo)) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "openProxySession", "returning void", null, null, new Object[0]);
                return;
            }
            if (!this.upc.isOracle()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "openProxySession", "returning void", null, null, new Object[0]);
                return;
            }
            OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
            if (oConn == null) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "openProxySession", "returning void", null, null, new Object[0]);
                return;
            }
            if (oConn.isProxySession()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "openProxySession", "returning void", null, null, new Object[0]);
                return;
            }
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)borrowCri;
            Properties newProxyProps = jdbcCri.getProxyProperties();
            if (newProxyProps == null) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "openProxySession", "returning void", null, null, new Object[0]);
                return;
            }
            int proxyType = jdbcCri.getProxyType();
            this.trace(Level.INFO, CLASS_NAME, "openProxySession", "Opening proxy session with Properties=={0}", null, null, newProxyProps);
            oConn.openProxySession(proxyType, newProxyProps);
            JDBCConnectionRetrievalInfo newConnCri = jdbcCri.getCopyWithNewProxyProperties(proxyType, newProxyProps);
            this.upc.setConnectionRetrievalInfo(newConnCri);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "openProxySession", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "openProxySession", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private void closeProxySession() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeProxySession", "entering args ()", null, null, new Object[0]);
            if (!this.upc.isOracle()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeProxySession", "returning void", null, null, new Object[0]);
                return;
            }
            OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
            ConnectionRetrievalInfo cri = this.upc.getConnectionRetrievalInfo();
            if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeProxySession", "returning void", null, null, new Object[0]);
                return;
            }
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            if (jdbcCri.getProxyProperties() == null) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeProxySession", "returning void", null, null, new Object[0]);
                return;
            }
            if (oConn == null) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeProxySession", "returning void", null, null, new Object[0]);
                return;
            }
            oConn.close(1);
            this.upc.setConnectionRetrievalInfo(jdbcCri.getCopyWithNewProxyProperties(-1, null));
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeProxySession", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "closeProxySession", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Debug(level=Debug.Level.FINEST)
    private String fetchContainerName() {
        try {
            block19: {
                String string;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "entering args ()", null, null, new Object[0]);
                if (!this.connectionSource.isMultitenantDatabase()) {
                    String string2 = "";
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "returning {0}", null, null, string2);
                    return string2;
                }
                OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
                if (oConn == null) {
                    String string3 = "";
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "returning {0}", null, null, string3);
                    return string3;
                }
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = oConn.createStatement();
                    String updateStr = "select sys_context('userenv','con_name') from dual";
                    rs = stmt.executeQuery("select sys_context('userenv','con_name') from dual");
                    if (!rs.next()) break block19;
                    String string4 = rs.getString(1);
                    string = string4;
                }
                catch (SQLException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "fetchContainerName", "", null, null, new Object[0]);
                    break block19;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "fetchContainerName", "", null, null, new Object[0]);
                    }
                }
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "returning {0}", null, null, string);
                return string;
            }
            String string = "";
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "returning {0}", null, null, string);
            return string;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private Set<String> fetchServicePlacement() {
        try {
            HashSet<String> instances;
            OracleConnection oConn;
            block23: {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "entering args ()", null, null, new Object[0]);
                if (!this.upc.isOracle()) {
                    HashSet<String> hashSet = new HashSet<String>();
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
                    return hashSet;
                }
                oConn = (OracleConnection)this.getPhysicalConnection();
                instances = new HashSet<String>();
                instances.add(this.serviceMember().name());
                if (!this.connectionSource.isMultitenantDatabase()) {
                    HashSet<String> hashSet = instances;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
                    return hashSet;
                }
                if (oConn == null) {
                    HashSet<String> hashSet = instances;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
                    return hashSet;
                }
                if (oConn.getVersionNumber() >= 12200 && this.connectionSource.isShareable()) break block23;
                HashSet<String> hashSet = instances;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
                return hashSet;
            }
            try {
                String sql = "select dbms_service_prvt.get_topology('" + this.serviceName() + "') from dual";
                try (Statement stmt = oConn.createStatement();
                     ResultSet rs = stmt.executeQuery(sql);){
                    String instancesStr = "";
                    if (rs.next()) {
                        instancesStr = rs.getString(1);
                    }
                    if (instancesStr != null && instancesStr.length() > 0) {
                        for (String instName : instancesStr.split(",")) {
                            instances.add(instName);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "fetchServicePlacement", "", null, null, new Object[0]);
            }
            HashSet<String> hashSet = instances;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
            return hashSet;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }
}

