/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.async.AsyncBorrowRequest;
import oracle.ucp.common.waitfreepool.PoolElement;

class CriStats {
    private final BorrowSemaphore borrowSemaphore = new BorrowSemaphore();
    private final Counter totalConnCount = new Counter(){
        private final AtomicInteger counter = new AtomicInteger(0);

        public String toString() {
            return "totalCounter=" + this.counter.get();
        }

        @Override
        public int getAndIncrement() {
            CriStats.this.handleAsyncRequests();
            int total = this.counter.getAndIncrement();
            CriStats.this.borrowSemaphore.release();
            return total;
        }

        @Override
        public int decrementAndGet() {
            int total = this.counter.decrementAndGet();
            CriStats.this.borrowSemaphore.reduce(1);
            return total;
        }

        @Override
        public int getAndDecrement() {
            int total = this.counter.getAndDecrement();
            CriStats.this.borrowSemaphore.reduce(1);
            return total;
        }

        @Override
        public int incrementAndGet() {
            CriStats.this.handleAsyncRequests();
            int total = this.counter.incrementAndGet();
            CriStats.this.borrowSemaphore.release();
            return total;
        }

        @Override
        public int get() {
            return this.counter.get();
        }
    };
    private final Counter borrowedConnCount = new Counter(){
        private final AtomicInteger counter = new AtomicInteger(0);

        public String toString() {
            return "borrowedCounter=" + this.counter.get();
        }

        @Override
        public int getAndIncrement() {
            int borrowed = this.counter.getAndIncrement();
            CriStats.this.borrowSemaphore.reduce(1);
            return borrowed;
        }

        @Override
        public int decrementAndGet() {
            CriStats.this.handleAsyncRequests();
            int borrowed = this.counter.decrementAndGet();
            CriStats.this.borrowSemaphore.release();
            return borrowed;
        }

        @Override
        public int getAndDecrement() {
            CriStats.this.handleAsyncRequests();
            int borrowed = this.counter.getAndDecrement();
            CriStats.this.borrowSemaphore.release();
            return borrowed;
        }

        @Override
        public int incrementAndGet() {
            int borrowed = this.counter.incrementAndGet();
            CriStats.this.borrowSemaphore.reduce(1);
            return borrowed;
        }

        @Override
        public int get() {
            return this.counter.get();
        }
    };
    private final ThreadLocal<Deque<PoolElement<CoreConnection>>> waitFreePoolCache = ThreadLocal.withInitial(LinkedList::new);
    private final Queue<AsyncBorrowRequest> asyncBorrowRequestQueue = new ConcurrentLinkedQueue<AsyncBorrowRequest>();

    CriStats() {
    }

    Counter totalConnCount() {
        return this.totalConnCount;
    }

    Counter borrowedConnCount() {
        return this.borrowedConnCount;
    }

    BorrowSemaphore getBorrowSemaphore() {
        return this.borrowSemaphore;
    }

    ThreadLocal<Deque<PoolElement<CoreConnection>>> getWaitFreePoolCache() {
        return this.waitFreePoolCache;
    }

    void addAsyncBorrowRequest(CompletableFuture<Void> cf, long timeToWait) {
        this.asyncBorrowRequestQueue.add(new AsyncBorrowRequest(cf, timeToWait, this.asyncBorrowRequestQueue));
    }

    private void handleAsyncRequests() {
        AsyncBorrowRequest request = this.asyncBorrowRequestQueue.poll();
        if (Objects.isNull(request)) {
            return;
        }
        request.trigger();
    }

    public String toString() {
        return "borrowSemaphore=[" + this.borrowSemaphore + "]" + ", " + this.totalConnCount().get() + ", " + this.borrowedConnCount().get();
    }

    class BorrowSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 4343640747504L;
        private AtomicLong acquireAttempts;
        private AtomicLong waitingAcquires;

        private BorrowSemaphore() {
            super(0, true);
            this.acquireAttempts = new AtomicLong(0L);
            this.waitingAcquires = new AtomicLong(0L);
        }

        private void reduce(int permits) {
            super.reducePermits(permits);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAcquire(long timeout, TimeUnit units) throws InterruptedException {
            this.acquireAttempts.incrementAndGet();
            this.waitingAcquires.incrementAndGet();
            try {
                boolean bl = super.tryAcquire(timeout, units);
                return bl;
            }
            finally {
                this.waitingAcquires.getAndDecrement();
            }
        }

        public long getWaitingAcquires() {
            long wa = this.waitingAcquires.get();
            assert (wa >= 0L);
            return wa;
        }

        @Override
        public String toString() {
            return "availPermits=" + this.availablePermits() + ", acquireAttempts=" + this.acquireAttempts.get() + ", queueLength=" + this.getQueueLength() + ", waitingAcquires=" + this.getWaitingAcquires();
        }
    }
}

