/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.oracle.OracleConnectionProxyFactory;
import oracle.ucp.util.UCPErrorHandler;

public class OracleConnectionConnectionPool
extends OracleJDBCConnectionPool {
    static final String CLASS_NAME = OracleConnectionConnectionPool.class.getName();
    protected boolean useVanillaObjects = false;
    protected AtomicBoolean isFirstBorrow = new AtomicBoolean(true);
    private final ConnectionProxyFactory cpf = new OracleConnectionProxyFactory();

    public OracleConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter, diagnosticsCollector);
    }

    public OracleConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public Connection getConnection(JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRetrievalInfo;
            Connection conn;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "getConnection", "entering args ({0})", null, null, jDBCConnectionRetrievalInfo);
            Connection connection = conn = (Connection)this.borrowConnection((ConnectionRetrievalInfo)connectionRetrievalInfo).getPhysicalConnection();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "getConnection", "returning {0}", null, null, connection);
            return connection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "getConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "borrowConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            long giveUp = this.computeBorrowGiveUpTimestamp();
            do {
                ConnectionInitializationCallback connInitCallback;
                void connectionRetrievalInfo2;
                OracleUniversalPooledConnection upc = (OracleUniversalPooledConnection)super.borrowConnection((ConnectionRetrievalInfo)connectionRetrievalInfo2);
                try {
                    if (this.isDRCPEnabled(upc) && connectionRetrievalInfo2.getLabels() == null) {
                        upc.attachServerConnection(null);
                    }
                }
                catch (SQLRecoverableException rexc) {
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    this.returnConnection(upc);
                    continue;
                }
                catch (SQLException ea) {
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    this.returnConnection(upc);
                    throw new UniversalConnectionPoolException(ea);
                }
                Object pconn = upc.getPhysicalConnection();
                if (this.isFirstBorrow.get()) {
                    this.useVanillaObjects = !pconn.getClass().getName().startsWith("oracle.jdbc.proxy");
                    this.isFirstBorrow.set(false);
                }
                upc.getDelegator().setReplayable(!this.useVanillaObjects);
                if (this.useVanillaObjects) {
                    this.core.connectionSource().setReplayable(false);
                }
                if (this.getConnectionLabelingCallback() == null && (connInitCallback = this.getConnectionInitializationCallback()) != null) {
                    try {
                        connInitCallback.initialize((Connection)pconn);
                    }
                    catch (RuntimeException | SQLException exc) {
                        upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                        this.returnConnection(upc);
                        throw UCPErrorHandler.newUniversalConnectionPoolException(271, exc);
                    }
                }
                try {
                    ((OracleConnection)pconn).beginRequest();
                }
                catch (SQLRecoverableException e) {
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    this.returnConnection(upc);
                    continue;
                }
                catch (Throwable exc) {
                    throw UCPErrorHandler.newUniversalConnectionPoolException(309, exc);
                }
                OracleUniversalPooledConnection oracleUniversalPooledConnection = upc;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "borrowConnection", "returning {0}", null, null, oracleUniversalPooledConnection);
                return oracleUniversalPooledConnection;
            } while (this.isStillOkayToBorrow(giveUp));
            throw new NoAvailableConnectionsException();
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "borrowConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public boolean returnConnection(Connection connection) throws UniversalConnectionPoolException {
        try {
            void connection2;
            boolean res;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "returnConnection", "entering args ({0})", null, null, connection);
            boolean bl = res = this.returnUsedPhysicalConnection(connection2);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "returnConnection", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "returnConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private boolean dropBadConnection(OracleUniversalPooledConnection oracleUniversalPooledConnection) throws UniversalConnectionPoolException {
        try {
            void oupc;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "dropBadConnection", "entering args ({0})", null, null, oracleUniversalPooledConnection);
            Object pconn = oupc.getPhysicalConnection();
            if (!((OracleConnection)pconn).isUsable(false)) {
                try {
                    oupc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                }
                catch (Throwable t) {
                    this.trace(Level.WARNING, CLASS_NAME, "dropBadConnection", "setting UPC status hit exception:", null, t, new Object[0]);
                }
                super.returnConnection((UniversalPooledConnection)oupc);
                boolean bl = true;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "dropBadConnection", "returning {0}", null, null, bl);
                return bl;
            }
            boolean bl = false;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "dropBadConnection", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "dropBadConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void returnConnection(UniversalPooledConnection universalPooledConnection) throws UniversalConnectionPoolException {
        try {
            void upc;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "returnConnection", "entering args ({0})", null, null, universalPooledConnection);
            OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)upc;
            Object pconn = upc.getPhysicalConnection();
            if (this.dropBadConnection(oupc)) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "returnConnection", "returning void", null, null, new Object[0]);
                return;
            }
            try {
                ((OracleConnection)pconn).endRequest();
            }
            catch (Throwable exc) {
                UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(310, exc);
                try {
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                }
                catch (Throwable t) {
                    this.trace(Level.WARNING, CLASS_NAME, "returnConnection", "setting UPC status hit exception:", null, t, new Object[0]);
                }
                super.returnConnection((UniversalPooledConnection)upc);
                throw ucpe;
            }
            if (this.dropBadConnection(oupc)) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "returnConnection", "returning void", null, null, new Object[0]);
                return;
            }
            try {
                if (this.isDRCPEnabled(oupc)) {
                    oupc.detachServerConnection(null);
                }
            }
            catch (SQLRecoverableException rexc) {
                oupc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
            }
            catch (SQLException ea) {
                oupc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                throw new UniversalConnectionPoolException(ea);
            }
            finally {
                super.returnConnection((UniversalPooledConnection)upc);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "returnConnection", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "returnConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    protected boolean needToConfigureConnection(UniversalPooledConnection universalPooledConnection, Properties properties) throws UniversalConnectionPoolException {
        try {
            boolean returnValue;
            block5: {
                void requestedLabels;
                OracleUniversalPooledConnection oconn;
                block6: {
                    boolean bl;
                    void pc;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "needToConfigureConnection", "entering args ({0}, {1})", null, null, universalPooledConnection, properties);
                    returnValue = false;
                    oconn = (OracleUniversalPooledConnection)pc;
                    try {
                        if (!this.isDRCPEnabled((UniversalPooledConnection)pc)) break block5;
                        if (!this.isDRCPMultiTagEnabled((UniversalPooledConnection)pc) || this.getDRCPPLSQLCallbackName((UniversalPooledConnection)pc) == null) break block6;
                        bl = false;
                    }
                    catch (SQLException ea) {
                        throw new UniversalConnectionPoolException(ea);
                    }
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "needToConfigureConnection", "returning {0}", null, null, bl);
                    return bl;
                }
                returnValue = !oconn.attachServerConnection((Properties)requestedLabels);
            }
            boolean bl = returnValue;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "needToConfigureConnection", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool", "needToConfigureConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    protected boolean isDRCPEnabled(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oconn = (OracleUniversalPooledConnection)pc;
        try {
            if (this.isDRCPEnabled == null) {
                this.isDRCPEnabled = oconn.isDRCPEnabled();
            }
        }
        catch (SQLException ea) {
            throw new UniversalConnectionPoolException(ea);
        }
        return this.isDRCPEnabled;
    }

    @Override
    protected boolean isDRCPMultiTagEnabled(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oconn = (OracleUniversalPooledConnection)pc;
        try {
            if (this.isDRCPMultiTagEnabled == null) {
                this.isDRCPMultiTagEnabled = oconn.isDRCPMultitagEnabled();
            }
        }
        catch (SQLException ea) {
            throw new UniversalConnectionPoolException(ea);
        }
        return this.isDRCPMultiTagEnabled;
    }

    @Override
    protected String getDRCPPLSQLCallbackName(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oconn = (OracleUniversalPooledConnection)pc;
        if (this.drcpPLSQLCallbackName == null) {
            this.drcpPLSQLCallbackName = oconn.getDRCPPLSQLCallbackName();
        }
        return this.drcpPLSQLCallbackName;
    }

    @Override
    protected ConnectionProxyFactory getProxyFactory() {
        return this.cpf;
    }
}

