/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.security.AccessController;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.TimerTask;

public class UCPTimerManagerImpl
implements TimerManager {
    private static final int NUMBER_OF_THREADS = 5;
    private static final ScheduledThreadPoolExecutor scheduler = AccessController.doPrivileged(() -> {
        ThreadFactory tf = new ThreadFactory(){
            private final AtomicInteger numCreatedThreads = new AtomicInteger(0);
            private static final String THREAD_NAME_PREFIX = "UCP-ScheduledThreadPoolExecutor-Thread-";

            @Override
            public Thread newThread(Runnable r) {
                Thread newT = new Thread(null, r, THREAD_NAME_PREFIX + this.numCreatedThreads.incrementAndGet());
                newT.setPriority(5);
                newT.setDaemon(true);
                return newT;
            }
        };
        return new ScheduledThreadPoolExecutor(5, tf);
    });
    private final Set<ScheduledFuture<?>> setScheduledFutures = new LinkedHashSet();
    private boolean running = false;

    private synchronized TimerHandle scheduleHelper(TimerTask task, long delay, long interval) {
        if (Objects.isNull(task)) {
            throw new NullPointerException("task is null");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("negative delay");
        }
        if (interval < 0L) {
            throw new IllegalArgumentException("negative interval");
        }
        final ScheduledFuture<?> future = interval > 0L ? scheduler.scheduleAtFixedRate(task, delay, interval, TimeUnit.MILLISECONDS) : scheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
        this.setScheduledFutures.add(future);
        final UCPTimerManagerImpl timerManagerThis = this;
        return new TimerHandle(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                Object object = timerManagerThis;
                synchronized (object) {
                    if (UCPTimerManagerImpl.this.setScheduledFutures.remove(future)) {
                        future.cancel(true);
                    }
                }
            }
        };
    }

    @Override
    public synchronized boolean isRunning() {
        return this.running;
    }

    @Override
    public synchronized TimerHandle schedule(TimerTask task, long delay, long interval) {
        return this.scheduleHelper(task, delay, interval);
    }

    @Override
    public synchronized TimerHandle scheduleAtFixedRate(TimerTask task, long delay, long interval) {
        return this.scheduleHelper(task, delay, interval);
    }

    @Override
    public synchronized void start() {
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        this.running = false;
    }
}

