/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.identity.Identity;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.model.DynamicGroup;
import com.oracle.bmc.identity.model.Group;
import com.oracle.bmc.identity.model.IdentityProvider;
import com.oracle.bmc.identity.model.IdentityProviderGroupSummary;
import com.oracle.bmc.identity.model.IdpGroupMapping;
import com.oracle.bmc.identity.model.MfaTotpDeviceSummary;
import com.oracle.bmc.identity.model.Policy;
import com.oracle.bmc.identity.model.TagDefaultSummary;
import com.oracle.bmc.identity.model.TagNamespaceSummary;
import com.oracle.bmc.identity.model.TagSummary;
import com.oracle.bmc.identity.model.User;
import com.oracle.bmc.identity.model.UserGroupMembership;
import com.oracle.bmc.identity.model.WorkRequestSummary;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.requests.ListDynamicGroupsRequest;
import com.oracle.bmc.identity.requests.ListGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProviderGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProvidersRequest;
import com.oracle.bmc.identity.requests.ListIdpGroupMappingsRequest;
import com.oracle.bmc.identity.requests.ListMfaTotpDevicesRequest;
import com.oracle.bmc.identity.requests.ListPoliciesRequest;
import com.oracle.bmc.identity.requests.ListTagDefaultsRequest;
import com.oracle.bmc.identity.requests.ListTagNamespacesRequest;
import com.oracle.bmc.identity.requests.ListTagsRequest;
import com.oracle.bmc.identity.requests.ListUserGroupMembershipsRequest;
import com.oracle.bmc.identity.requests.ListUsersRequest;
import com.oracle.bmc.identity.requests.ListWorkRequestsRequest;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.identity.responses.ListDynamicGroupsResponse;
import com.oracle.bmc.identity.responses.ListGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProviderGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProvidersResponse;
import com.oracle.bmc.identity.responses.ListIdpGroupMappingsResponse;
import com.oracle.bmc.identity.responses.ListMfaTotpDevicesResponse;
import com.oracle.bmc.identity.responses.ListPoliciesResponse;
import com.oracle.bmc.identity.responses.ListTagDefaultsResponse;
import com.oracle.bmc.identity.responses.ListTagNamespacesResponse;
import com.oracle.bmc.identity.responses.ListTagsResponse;
import com.oracle.bmc.identity.responses.ListUserGroupMembershipsResponse;
import com.oracle.bmc.identity.responses.ListUsersResponse;
import com.oracle.bmc.identity.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class IdentityPaginators {
    private final Identity client;

    public Iterable<ListCompartmentsResponse> listCompartmentsResponseIterator(final ListCompartmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCompartmentsRequest.Builder>(){

            public ListCompartmentsRequest.Builder get() {
                return ListCompartmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCompartmentsResponse, String>(){

            public String apply(ListCompartmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCompartmentsRequest.Builder>, ListCompartmentsRequest>(){

            public ListCompartmentsRequest apply(RequestBuilderAndToken<ListCompartmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListCompartmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCompartmentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListCompartmentsRequest, ListCompartmentsResponse>(){

            public ListCompartmentsResponse apply(ListCompartmentsRequest request) {
                return IdentityPaginators.this.client.listCompartments(request);
            }
        });
    }

    public Iterable<Compartment> listCompartmentsRecordIterator(final ListCompartmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCompartmentsRequest.Builder>(){

            public ListCompartmentsRequest.Builder get() {
                return ListCompartmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCompartmentsResponse, String>(){

            public String apply(ListCompartmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCompartmentsRequest.Builder>, ListCompartmentsRequest>(){

            public ListCompartmentsRequest apply(RequestBuilderAndToken<ListCompartmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListCompartmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCompartmentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListCompartmentsRequest, ListCompartmentsResponse>(){

            public ListCompartmentsResponse apply(ListCompartmentsRequest request) {
                return IdentityPaginators.this.client.listCompartments(request);
            }
        }, (Function)new Function<ListCompartmentsResponse, List<Compartment>>(){

            public List<Compartment> apply(ListCompartmentsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDynamicGroupsResponse> listDynamicGroupsResponseIterator(final ListDynamicGroupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDynamicGroupsRequest.Builder>(){

            public ListDynamicGroupsRequest.Builder get() {
                return ListDynamicGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDynamicGroupsResponse, String>(){

            public String apply(ListDynamicGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDynamicGroupsRequest.Builder>, ListDynamicGroupsRequest>(){

            public ListDynamicGroupsRequest apply(RequestBuilderAndToken<ListDynamicGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDynamicGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDynamicGroupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDynamicGroupsRequest, ListDynamicGroupsResponse>(){

            public ListDynamicGroupsResponse apply(ListDynamicGroupsRequest request) {
                return IdentityPaginators.this.client.listDynamicGroups(request);
            }
        });
    }

    public Iterable<DynamicGroup> listDynamicGroupsRecordIterator(final ListDynamicGroupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDynamicGroupsRequest.Builder>(){

            public ListDynamicGroupsRequest.Builder get() {
                return ListDynamicGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDynamicGroupsResponse, String>(){

            public String apply(ListDynamicGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDynamicGroupsRequest.Builder>, ListDynamicGroupsRequest>(){

            public ListDynamicGroupsRequest apply(RequestBuilderAndToken<ListDynamicGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDynamicGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDynamicGroupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDynamicGroupsRequest, ListDynamicGroupsResponse>(){

            public ListDynamicGroupsResponse apply(ListDynamicGroupsRequest request) {
                return IdentityPaginators.this.client.listDynamicGroups(request);
            }
        }, (Function)new Function<ListDynamicGroupsResponse, List<DynamicGroup>>(){

            public List<DynamicGroup> apply(ListDynamicGroupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListGroupsResponse> listGroupsResponseIterator(final ListGroupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListGroupsRequest.Builder>(){

            public ListGroupsRequest.Builder get() {
                return ListGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGroupsResponse, String>(){

            public String apply(ListGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGroupsRequest.Builder>, ListGroupsRequest>(){

            public ListGroupsRequest apply(RequestBuilderAndToken<ListGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGroupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListGroupsRequest, ListGroupsResponse>(){

            public ListGroupsResponse apply(ListGroupsRequest request) {
                return IdentityPaginators.this.client.listGroups(request);
            }
        });
    }

    public Iterable<Group> listGroupsRecordIterator(final ListGroupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListGroupsRequest.Builder>(){

            public ListGroupsRequest.Builder get() {
                return ListGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGroupsResponse, String>(){

            public String apply(ListGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGroupsRequest.Builder>, ListGroupsRequest>(){

            public ListGroupsRequest apply(RequestBuilderAndToken<ListGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGroupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListGroupsRequest, ListGroupsResponse>(){

            public ListGroupsResponse apply(ListGroupsRequest request) {
                return IdentityPaginators.this.client.listGroups(request);
            }
        }, (Function)new Function<ListGroupsResponse, List<Group>>(){

            public List<Group> apply(ListGroupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIdentityProviderGroupsResponse> listIdentityProviderGroupsResponseIterator(final ListIdentityProviderGroupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIdentityProviderGroupsRequest.Builder>(){

            public ListIdentityProviderGroupsRequest.Builder get() {
                return ListIdentityProviderGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIdentityProviderGroupsResponse, String>(){

            public String apply(ListIdentityProviderGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIdentityProviderGroupsRequest.Builder>, ListIdentityProviderGroupsRequest>(){

            public ListIdentityProviderGroupsRequest apply(RequestBuilderAndToken<ListIdentityProviderGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIdentityProviderGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIdentityProviderGroupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse>(){

            public ListIdentityProviderGroupsResponse apply(ListIdentityProviderGroupsRequest request) {
                return IdentityPaginators.this.client.listIdentityProviderGroups(request);
            }
        });
    }

    public Iterable<IdentityProviderGroupSummary> listIdentityProviderGroupsRecordIterator(final ListIdentityProviderGroupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIdentityProviderGroupsRequest.Builder>(){

            public ListIdentityProviderGroupsRequest.Builder get() {
                return ListIdentityProviderGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIdentityProviderGroupsResponse, String>(){

            public String apply(ListIdentityProviderGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIdentityProviderGroupsRequest.Builder>, ListIdentityProviderGroupsRequest>(){

            public ListIdentityProviderGroupsRequest apply(RequestBuilderAndToken<ListIdentityProviderGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIdentityProviderGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIdentityProviderGroupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse>(){

            public ListIdentityProviderGroupsResponse apply(ListIdentityProviderGroupsRequest request) {
                return IdentityPaginators.this.client.listIdentityProviderGroups(request);
            }
        }, (Function)new Function<ListIdentityProviderGroupsResponse, List<IdentityProviderGroupSummary>>(){

            public List<IdentityProviderGroupSummary> apply(ListIdentityProviderGroupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIdentityProvidersResponse> listIdentityProvidersResponseIterator(final ListIdentityProvidersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIdentityProvidersRequest.Builder>(){

            public ListIdentityProvidersRequest.Builder get() {
                return ListIdentityProvidersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIdentityProvidersResponse, String>(){

            public String apply(ListIdentityProvidersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIdentityProvidersRequest.Builder>, ListIdentityProvidersRequest>(){

            public ListIdentityProvidersRequest apply(RequestBuilderAndToken<ListIdentityProvidersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIdentityProvidersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIdentityProvidersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIdentityProvidersRequest, ListIdentityProvidersResponse>(){

            public ListIdentityProvidersResponse apply(ListIdentityProvidersRequest request) {
                return IdentityPaginators.this.client.listIdentityProviders(request);
            }
        });
    }

    public Iterable<IdentityProvider> listIdentityProvidersRecordIterator(final ListIdentityProvidersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIdentityProvidersRequest.Builder>(){

            public ListIdentityProvidersRequest.Builder get() {
                return ListIdentityProvidersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIdentityProvidersResponse, String>(){

            public String apply(ListIdentityProvidersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIdentityProvidersRequest.Builder>, ListIdentityProvidersRequest>(){

            public ListIdentityProvidersRequest apply(RequestBuilderAndToken<ListIdentityProvidersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIdentityProvidersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIdentityProvidersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIdentityProvidersRequest, ListIdentityProvidersResponse>(){

            public ListIdentityProvidersResponse apply(ListIdentityProvidersRequest request) {
                return IdentityPaginators.this.client.listIdentityProviders(request);
            }
        }, (Function)new Function<ListIdentityProvidersResponse, List<IdentityProvider>>(){

            public List<IdentityProvider> apply(ListIdentityProvidersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIdpGroupMappingsResponse> listIdpGroupMappingsResponseIterator(final ListIdpGroupMappingsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIdpGroupMappingsRequest.Builder>(){

            public ListIdpGroupMappingsRequest.Builder get() {
                return ListIdpGroupMappingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIdpGroupMappingsResponse, String>(){

            public String apply(ListIdpGroupMappingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIdpGroupMappingsRequest.Builder>, ListIdpGroupMappingsRequest>(){

            public ListIdpGroupMappingsRequest apply(RequestBuilderAndToken<ListIdpGroupMappingsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIdpGroupMappingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIdpGroupMappingsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse>(){

            public ListIdpGroupMappingsResponse apply(ListIdpGroupMappingsRequest request) {
                return IdentityPaginators.this.client.listIdpGroupMappings(request);
            }
        });
    }

    public Iterable<IdpGroupMapping> listIdpGroupMappingsRecordIterator(final ListIdpGroupMappingsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIdpGroupMappingsRequest.Builder>(){

            public ListIdpGroupMappingsRequest.Builder get() {
                return ListIdpGroupMappingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIdpGroupMappingsResponse, String>(){

            public String apply(ListIdpGroupMappingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIdpGroupMappingsRequest.Builder>, ListIdpGroupMappingsRequest>(){

            public ListIdpGroupMappingsRequest apply(RequestBuilderAndToken<ListIdpGroupMappingsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIdpGroupMappingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIdpGroupMappingsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse>(){

            public ListIdpGroupMappingsResponse apply(ListIdpGroupMappingsRequest request) {
                return IdentityPaginators.this.client.listIdpGroupMappings(request);
            }
        }, (Function)new Function<ListIdpGroupMappingsResponse, List<IdpGroupMapping>>(){

            public List<IdpGroupMapping> apply(ListIdpGroupMappingsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMfaTotpDevicesResponse> listMfaTotpDevicesResponseIterator(final ListMfaTotpDevicesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMfaTotpDevicesRequest.Builder>(){

            public ListMfaTotpDevicesRequest.Builder get() {
                return ListMfaTotpDevicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMfaTotpDevicesResponse, String>(){

            public String apply(ListMfaTotpDevicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMfaTotpDevicesRequest.Builder>, ListMfaTotpDevicesRequest>(){

            public ListMfaTotpDevicesRequest apply(RequestBuilderAndToken<ListMfaTotpDevicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMfaTotpDevicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMfaTotpDevicesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse>(){

            public ListMfaTotpDevicesResponse apply(ListMfaTotpDevicesRequest request) {
                return IdentityPaginators.this.client.listMfaTotpDevices(request);
            }
        });
    }

    public Iterable<MfaTotpDeviceSummary> listMfaTotpDevicesRecordIterator(final ListMfaTotpDevicesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMfaTotpDevicesRequest.Builder>(){

            public ListMfaTotpDevicesRequest.Builder get() {
                return ListMfaTotpDevicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMfaTotpDevicesResponse, String>(){

            public String apply(ListMfaTotpDevicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMfaTotpDevicesRequest.Builder>, ListMfaTotpDevicesRequest>(){

            public ListMfaTotpDevicesRequest apply(RequestBuilderAndToken<ListMfaTotpDevicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMfaTotpDevicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMfaTotpDevicesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse>(){

            public ListMfaTotpDevicesResponse apply(ListMfaTotpDevicesRequest request) {
                return IdentityPaginators.this.client.listMfaTotpDevices(request);
            }
        }, (Function)new Function<ListMfaTotpDevicesResponse, List<MfaTotpDeviceSummary>>(){

            public List<MfaTotpDeviceSummary> apply(ListMfaTotpDevicesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPoliciesResponse> listPoliciesResponseIterator(final ListPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPoliciesRequest.Builder>(){

            public ListPoliciesRequest.Builder get() {
                return ListPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPoliciesResponse, String>(){

            public String apply(ListPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPoliciesRequest.Builder>, ListPoliciesRequest>(){

            public ListPoliciesRequest apply(RequestBuilderAndToken<ListPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPoliciesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPoliciesRequest, ListPoliciesResponse>(){

            public ListPoliciesResponse apply(ListPoliciesRequest request) {
                return IdentityPaginators.this.client.listPolicies(request);
            }
        });
    }

    public Iterable<Policy> listPoliciesRecordIterator(final ListPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPoliciesRequest.Builder>(){

            public ListPoliciesRequest.Builder get() {
                return ListPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPoliciesResponse, String>(){

            public String apply(ListPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPoliciesRequest.Builder>, ListPoliciesRequest>(){

            public ListPoliciesRequest apply(RequestBuilderAndToken<ListPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPoliciesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPoliciesRequest, ListPoliciesResponse>(){

            public ListPoliciesResponse apply(ListPoliciesRequest request) {
                return IdentityPaginators.this.client.listPolicies(request);
            }
        }, (Function)new Function<ListPoliciesResponse, List<Policy>>(){

            public List<Policy> apply(ListPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTagDefaultsResponse> listTagDefaultsResponseIterator(final ListTagDefaultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTagDefaultsRequest.Builder>(){

            public ListTagDefaultsRequest.Builder get() {
                return ListTagDefaultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTagDefaultsResponse, String>(){

            public String apply(ListTagDefaultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTagDefaultsRequest.Builder>, ListTagDefaultsRequest>(){

            public ListTagDefaultsRequest apply(RequestBuilderAndToken<ListTagDefaultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTagDefaultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTagDefaultsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTagDefaultsRequest, ListTagDefaultsResponse>(){

            public ListTagDefaultsResponse apply(ListTagDefaultsRequest request) {
                return IdentityPaginators.this.client.listTagDefaults(request);
            }
        });
    }

    public Iterable<TagDefaultSummary> listTagDefaultsRecordIterator(final ListTagDefaultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTagDefaultsRequest.Builder>(){

            public ListTagDefaultsRequest.Builder get() {
                return ListTagDefaultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTagDefaultsResponse, String>(){

            public String apply(ListTagDefaultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTagDefaultsRequest.Builder>, ListTagDefaultsRequest>(){

            public ListTagDefaultsRequest apply(RequestBuilderAndToken<ListTagDefaultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTagDefaultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTagDefaultsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTagDefaultsRequest, ListTagDefaultsResponse>(){

            public ListTagDefaultsResponse apply(ListTagDefaultsRequest request) {
                return IdentityPaginators.this.client.listTagDefaults(request);
            }
        }, (Function)new Function<ListTagDefaultsResponse, List<TagDefaultSummary>>(){

            public List<TagDefaultSummary> apply(ListTagDefaultsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTagNamespacesResponse> listTagNamespacesResponseIterator(final ListTagNamespacesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTagNamespacesRequest.Builder>(){

            public ListTagNamespacesRequest.Builder get() {
                return ListTagNamespacesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTagNamespacesResponse, String>(){

            public String apply(ListTagNamespacesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTagNamespacesRequest.Builder>, ListTagNamespacesRequest>(){

            public ListTagNamespacesRequest apply(RequestBuilderAndToken<ListTagNamespacesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTagNamespacesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTagNamespacesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTagNamespacesRequest, ListTagNamespacesResponse>(){

            public ListTagNamespacesResponse apply(ListTagNamespacesRequest request) {
                return IdentityPaginators.this.client.listTagNamespaces(request);
            }
        });
    }

    public Iterable<TagNamespaceSummary> listTagNamespacesRecordIterator(final ListTagNamespacesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTagNamespacesRequest.Builder>(){

            public ListTagNamespacesRequest.Builder get() {
                return ListTagNamespacesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTagNamespacesResponse, String>(){

            public String apply(ListTagNamespacesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTagNamespacesRequest.Builder>, ListTagNamespacesRequest>(){

            public ListTagNamespacesRequest apply(RequestBuilderAndToken<ListTagNamespacesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTagNamespacesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTagNamespacesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTagNamespacesRequest, ListTagNamespacesResponse>(){

            public ListTagNamespacesResponse apply(ListTagNamespacesRequest request) {
                return IdentityPaginators.this.client.listTagNamespaces(request);
            }
        }, (Function)new Function<ListTagNamespacesResponse, List<TagNamespaceSummary>>(){

            public List<TagNamespaceSummary> apply(ListTagNamespacesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTagsResponse> listTagsResponseIterator(final ListTagsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTagsRequest.Builder>(){

            public ListTagsRequest.Builder get() {
                return ListTagsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTagsResponse, String>(){

            public String apply(ListTagsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTagsRequest.Builder>, ListTagsRequest>(){

            public ListTagsRequest apply(RequestBuilderAndToken<ListTagsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTagsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTagsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTagsRequest, ListTagsResponse>(){

            public ListTagsResponse apply(ListTagsRequest request) {
                return IdentityPaginators.this.client.listTags(request);
            }
        });
    }

    public Iterable<TagSummary> listTagsRecordIterator(final ListTagsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTagsRequest.Builder>(){

            public ListTagsRequest.Builder get() {
                return ListTagsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTagsResponse, String>(){

            public String apply(ListTagsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTagsRequest.Builder>, ListTagsRequest>(){

            public ListTagsRequest apply(RequestBuilderAndToken<ListTagsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTagsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTagsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTagsRequest, ListTagsResponse>(){

            public ListTagsResponse apply(ListTagsRequest request) {
                return IdentityPaginators.this.client.listTags(request);
            }
        }, (Function)new Function<ListTagsResponse, List<TagSummary>>(){

            public List<TagSummary> apply(ListTagsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListUserGroupMembershipsResponse> listUserGroupMembershipsResponseIterator(final ListUserGroupMembershipsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListUserGroupMembershipsRequest.Builder>(){

            public ListUserGroupMembershipsRequest.Builder get() {
                return ListUserGroupMembershipsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUserGroupMembershipsResponse, String>(){

            public String apply(ListUserGroupMembershipsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUserGroupMembershipsRequest.Builder>, ListUserGroupMembershipsRequest>(){

            public ListUserGroupMembershipsRequest apply(RequestBuilderAndToken<ListUserGroupMembershipsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListUserGroupMembershipsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUserGroupMembershipsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse>(){

            public ListUserGroupMembershipsResponse apply(ListUserGroupMembershipsRequest request) {
                return IdentityPaginators.this.client.listUserGroupMemberships(request);
            }
        });
    }

    public Iterable<UserGroupMembership> listUserGroupMembershipsRecordIterator(final ListUserGroupMembershipsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListUserGroupMembershipsRequest.Builder>(){

            public ListUserGroupMembershipsRequest.Builder get() {
                return ListUserGroupMembershipsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUserGroupMembershipsResponse, String>(){

            public String apply(ListUserGroupMembershipsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUserGroupMembershipsRequest.Builder>, ListUserGroupMembershipsRequest>(){

            public ListUserGroupMembershipsRequest apply(RequestBuilderAndToken<ListUserGroupMembershipsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListUserGroupMembershipsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUserGroupMembershipsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse>(){

            public ListUserGroupMembershipsResponse apply(ListUserGroupMembershipsRequest request) {
                return IdentityPaginators.this.client.listUserGroupMemberships(request);
            }
        }, (Function)new Function<ListUserGroupMembershipsResponse, List<UserGroupMembership>>(){

            public List<UserGroupMembership> apply(ListUserGroupMembershipsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListUsersResponse> listUsersResponseIterator(final ListUsersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListUsersRequest.Builder>(){

            public ListUsersRequest.Builder get() {
                return ListUsersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUsersResponse, String>(){

            public String apply(ListUsersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUsersRequest.Builder>, ListUsersRequest>(){

            public ListUsersRequest apply(RequestBuilderAndToken<ListUsersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListUsersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUsersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListUsersRequest, ListUsersResponse>(){

            public ListUsersResponse apply(ListUsersRequest request) {
                return IdentityPaginators.this.client.listUsers(request);
            }
        });
    }

    public Iterable<User> listUsersRecordIterator(final ListUsersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListUsersRequest.Builder>(){

            public ListUsersRequest.Builder get() {
                return ListUsersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUsersResponse, String>(){

            public String apply(ListUsersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUsersRequest.Builder>, ListUsersRequest>(){

            public ListUsersRequest apply(RequestBuilderAndToken<ListUsersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListUsersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUsersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListUsersRequest, ListUsersResponse>(){

            public ListUsersResponse apply(ListUsersRequest request) {
                return IdentityPaginators.this.client.listUsers(request);
            }
        }, (Function)new Function<ListUsersResponse, List<User>>(){

            public List<User> apply(ListUsersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return IdentityPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return IdentityPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public IdentityPaginators(Identity client) {
        this.client = client;
    }
}

