/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.CreateAuthTokenDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateAuthTokenRequest
extends BmcRequest {
    private CreateAuthTokenDetails createAuthTokenDetails;
    private String userId;
    private String opcRetryToken;

    @ConstructorProperties(value={"createAuthTokenDetails", "userId", "opcRetryToken"})
    CreateAuthTokenRequest(CreateAuthTokenDetails createAuthTokenDetails, String userId, String opcRetryToken) {
        this.createAuthTokenDetails = createAuthTokenDetails;
        this.userId = userId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateAuthTokenDetails getCreateAuthTokenDetails() {
        return this.createAuthTokenDetails;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateAuthTokenDetails createAuthTokenDetails;
        private String userId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateAuthTokenRequest o) {
            this.createAuthTokenDetails(o.getCreateAuthTokenDetails());
            this.userId(o.getUserId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateAuthTokenRequest build() {
            CreateAuthTokenRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createAuthTokenDetails(CreateAuthTokenDetails createAuthTokenDetails) {
            this.createAuthTokenDetails = createAuthTokenDetails;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateAuthTokenRequest buildWithoutInvocationCallback() {
            return new CreateAuthTokenRequest(this.createAuthTokenDetails, this.userId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateAuthTokenRequest.Builder(createAuthTokenDetails=" + this.createAuthTokenDetails + ", userId=" + this.userId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

