/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.CreateUserDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateUserRequest
extends BmcRequest {
    private CreateUserDetails createUserDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createUserDetails", "opcRetryToken"})
    CreateUserRequest(CreateUserDetails createUserDetails, String opcRetryToken) {
        this.createUserDetails = createUserDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateUserDetails getCreateUserDetails() {
        return this.createUserDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateUserDetails createUserDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateUserRequest o) {
            this.createUserDetails(o.getCreateUserDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateUserRequest build() {
            CreateUserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createUserDetails(CreateUserDetails createUserDetails) {
            this.createUserDetails = createUserDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateUserRequest buildWithoutInvocationCallback() {
            return new CreateUserRequest(this.createUserDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateUserRequest.Builder(createUserDetails=" + this.createUserDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

