/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteSwiftPasswordRequest
extends BmcRequest {
    private String userId;
    private String swiftPasswordId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "swiftPasswordId", "ifMatch"})
    DeleteSwiftPasswordRequest(String userId, String swiftPasswordId, String ifMatch) {
        this.userId = userId;
        this.swiftPasswordId = swiftPasswordId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSwiftPasswordId() {
        return this.swiftPasswordId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private String swiftPasswordId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteSwiftPasswordRequest o) {
            this.userId(o.getUserId());
            this.swiftPasswordId(o.getSwiftPasswordId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteSwiftPasswordRequest build() {
            DeleteSwiftPasswordRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder swiftPasswordId(String swiftPasswordId) {
            this.swiftPasswordId = swiftPasswordId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteSwiftPasswordRequest buildWithoutInvocationCallback() {
            return new DeleteSwiftPasswordRequest(this.userId, this.swiftPasswordId, this.ifMatch);
        }

        public String toString() {
            return "DeleteSwiftPasswordRequest.Builder(userId=" + this.userId + ", swiftPasswordId=" + this.swiftPasswordId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

