/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListWorkRequestsRequest
extends BmcRequest {
    private String compartmentId;
    private String page;
    private Integer limit;
    private String resourceIdentifier;

    @ConstructorProperties(value={"compartmentId", "page", "limit", "resourceIdentifier"})
    ListWorkRequestsRequest(String compartmentId, String page, Integer limit, String resourceIdentifier) {
        this.compartmentId = compartmentId;
        this.page = page;
        this.limit = limit;
        this.resourceIdentifier = resourceIdentifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public static class Builder {
        private String compartmentId;
        private String page;
        private Integer limit;
        private String resourceIdentifier;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.resourceIdentifier(o.getResourceIdentifier());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestsRequest build() {
            ListWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public ListWorkRequestsRequest buildWithoutInvocationCallback() {
            return new ListWorkRequestsRequest(this.compartmentId, this.page, this.limit, this.resourceIdentifier);
        }

        public String toString() {
            return "ListWorkRequestsRequest.Builder(compartmentId=" + this.compartmentId + ", page=" + this.page + ", limit=" + this.limit + ", resourceIdentifier=" + this.resourceIdentifier + ")";
        }
    }
}

