/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdatePolicyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdatePolicyRequest
extends BmcRequest {
    private String policyId;
    private UpdatePolicyDetails updatePolicyDetails;
    private String ifMatch;

    @ConstructorProperties(value={"policyId", "updatePolicyDetails", "ifMatch"})
    UpdatePolicyRequest(String policyId, UpdatePolicyDetails updatePolicyDetails, String ifMatch) {
        this.policyId = policyId;
        this.updatePolicyDetails = updatePolicyDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public UpdatePolicyDetails getUpdatePolicyDetails() {
        return this.updatePolicyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String policyId;
        private UpdatePolicyDetails updatePolicyDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePolicyRequest o) {
            this.policyId(o.getPolicyId());
            this.updatePolicyDetails(o.getUpdatePolicyDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePolicyRequest build() {
            UpdatePolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public Builder updatePolicyDetails(UpdatePolicyDetails updatePolicyDetails) {
            this.updatePolicyDetails = updatePolicyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdatePolicyRequest buildWithoutInvocationCallback() {
            return new UpdatePolicyRequest(this.policyId, this.updatePolicyDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdatePolicyRequest.Builder(policyId=" + this.policyId + ", updatePolicyDetails=" + this.updatePolicyDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

