/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdateSwiftPasswordDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateSwiftPasswordRequest
extends BmcRequest {
    private String userId;
    private String swiftPasswordId;
    private UpdateSwiftPasswordDetails updateSwiftPasswordDetails;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "swiftPasswordId", "updateSwiftPasswordDetails", "ifMatch"})
    UpdateSwiftPasswordRequest(String userId, String swiftPasswordId, UpdateSwiftPasswordDetails updateSwiftPasswordDetails, String ifMatch) {
        this.userId = userId;
        this.swiftPasswordId = swiftPasswordId;
        this.updateSwiftPasswordDetails = updateSwiftPasswordDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSwiftPasswordId() {
        return this.swiftPasswordId;
    }

    public UpdateSwiftPasswordDetails getUpdateSwiftPasswordDetails() {
        return this.updateSwiftPasswordDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private String swiftPasswordId;
        private UpdateSwiftPasswordDetails updateSwiftPasswordDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSwiftPasswordRequest o) {
            this.userId(o.getUserId());
            this.swiftPasswordId(o.getSwiftPasswordId());
            this.updateSwiftPasswordDetails(o.getUpdateSwiftPasswordDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSwiftPasswordRequest build() {
            UpdateSwiftPasswordRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder swiftPasswordId(String swiftPasswordId) {
            this.swiftPasswordId = swiftPasswordId;
            return this;
        }

        public Builder updateSwiftPasswordDetails(UpdateSwiftPasswordDetails updateSwiftPasswordDetails) {
            this.updateSwiftPasswordDetails = updateSwiftPasswordDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateSwiftPasswordRequest buildWithoutInvocationCallback() {
            return new UpdateSwiftPasswordRequest(this.userId, this.swiftPasswordId, this.updateSwiftPasswordDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateSwiftPasswordRequest.Builder(userId=" + this.userId + ", swiftPasswordId=" + this.swiftPasswordId + ", updateSwiftPasswordDetails=" + this.updateSwiftPasswordDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

