/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.CreateApiKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UploadApiKeyRequest
extends BmcRequest {
    private String userId;
    private CreateApiKeyDetails createApiKeyDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"userId", "createApiKeyDetails", "opcRetryToken"})
    UploadApiKeyRequest(String userId, CreateApiKeyDetails createApiKeyDetails, String opcRetryToken) {
        this.userId = userId;
        this.createApiKeyDetails = createApiKeyDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public CreateApiKeyDetails getCreateApiKeyDetails() {
        return this.createApiKeyDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String userId;
        private CreateApiKeyDetails createApiKeyDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UploadApiKeyRequest o) {
            this.userId(o.getUserId());
            this.createApiKeyDetails(o.getCreateApiKeyDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UploadApiKeyRequest build() {
            UploadApiKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder createApiKeyDetails(CreateApiKeyDetails createApiKeyDetails) {
            this.createApiKeyDetails = createApiKeyDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public UploadApiKeyRequest buildWithoutInvocationCallback() {
            return new UploadApiKeyRequest(this.userId, this.createApiKeyDetails, this.opcRetryToken);
        }

        public String toString() {
            return "UploadApiKeyRequest.Builder(userId=" + this.userId + ", createApiKeyDetails=" + this.createApiKeyDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

