/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.CustomerSecretKey;
import java.beans.ConstructorProperties;

public class CreateCustomerSecretKeyResponse {
    private String opcRequestId;
    private String etag;
    private CustomerSecretKey customerSecretKey;

    @ConstructorProperties(value={"opcRequestId", "etag", "customerSecretKey"})
    CreateCustomerSecretKeyResponse(String opcRequestId, String etag, CustomerSecretKey customerSecretKey) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.customerSecretKey = customerSecretKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public CustomerSecretKey getCustomerSecretKey() {
        return this.customerSecretKey;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private CustomerSecretKey customerSecretKey;

        public Builder copy(CreateCustomerSecretKeyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.customerSecretKey(o.getCustomerSecretKey());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder customerSecretKey(CustomerSecretKey customerSecretKey) {
            this.customerSecretKey = customerSecretKey;
            return this;
        }

        public CreateCustomerSecretKeyResponse build() {
            return new CreateCustomerSecretKeyResponse(this.opcRequestId, this.etag, this.customerSecretKey);
        }

        public String toString() {
            return "CreateCustomerSecretKeyResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", customerSecretKey=" + this.customerSecretKey + ")";
        }
    }
}

