/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.DynamicGroup;
import java.beans.ConstructorProperties;

public class CreateDynamicGroupResponse {
    private String opcRequestId;
    private String etag;
    private DynamicGroup dynamicGroup;

    @ConstructorProperties(value={"opcRequestId", "etag", "dynamicGroup"})
    CreateDynamicGroupResponse(String opcRequestId, String etag, DynamicGroup dynamicGroup) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.dynamicGroup = dynamicGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public DynamicGroup getDynamicGroup() {
        return this.dynamicGroup;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private DynamicGroup dynamicGroup;

        public Builder copy(CreateDynamicGroupResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.dynamicGroup(o.getDynamicGroup());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder dynamicGroup(DynamicGroup dynamicGroup) {
            this.dynamicGroup = dynamicGroup;
            return this;
        }

        public CreateDynamicGroupResponse build() {
            return new CreateDynamicGroupResponse(this.opcRequestId, this.etag, this.dynamicGroup);
        }

        public String toString() {
            return "CreateDynamicGroupResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", dynamicGroup=" + this.dynamicGroup + ")";
        }
    }
}

